#ifndef __GLTEXTURE_H__
#define __GLTEXTURE_H__

#include "defs.h"

class GLTexture : public Texture {
public:

	GLTexture();
	GLTexture(const GLTexture&);
	virtual ~GLTexture();

	GLTexture& operator=(const GLTexture&);

	virtual void bind();
	virtual void create(const char*,int);

private:

	UINT m_cubedirs[6];

	void copy(const GLTexture&);

	void apply_filter(int);
	void apply_wrap();
	void apply_texgen();
	void apply_combine();

	void create_rendertexture();
	void loadCubeMap(const char*);
	void extract_suffix(char*,char*);
};

#endif