#ifndef __GLRENDERER_H__
#define __GLRENDERER_H__

#include "defs.h"
#include "glwindow.h"
#include "gltransformer.h"
#include "glviewer.h"
#include "glmaterial.h"
#include "gllight.h"
#include "glfog.h"
#include "gltexture.h"
#include "glfrustum.h"
#include "glprimitive.h"
#include "glfont.h"
#include "gltexturecombiner.h"
#include "glvtxshader.h"
#include "glrenderproc.h"
#include "glpixelshader.h"
#include "glvertexarray.h"

// DLL Defs
#ifdef GLRENDERER_EXPORTS
#define GLRENDERER_API __declspec(dllexport)
#else
#define GLRENDERER_API __declspec(dllimport)
#endif

class GLRenderer : public Renderer {
public:

	GLRenderer(HINSTANCE);

	virtual void init();
	virtual void clearBuffers();
	virtual Window* getWindow();
//	virtual void getFeatureDescriptor()=0;

	virtual void render(Primitive*);
	virtual void redirectTexture(Texture*);
	virtual void commitTexture(bool,Texture*);
	virtual void text(int,int, Font*,const char*, ...);

	// *** T&L ***
	// State Control
	virtual void setTexCombiner(TextureCombiner*);
	virtual void setFillMode(int);
	virtual void setShadeModel(int);
	virtual void setZBuffer(bool,int);
	virtual void setBlender(bool,int,int);
	virtual void setStencilFunc(bool,int,int,int);
	virtual void setStencilOp(int,int,int);

	// Eye Coordinates
	virtual void setCamera(Transformer*);
	virtual Transformer* getCamera();

	// *** Factory Like Stuff *** //
	virtual void* newObject(int);
	virtual void deleteObject(void*);

private:

	void loadExtensions();
	void render_vertex(const Vertex&,Material*,int);

	TextureCombiner* m_texcombiner;
	Transformer* m_camera;
	op_rect m_savedvp;
};

#endif