#include "stdafx.h"
#include "glprimitive.h"

GLPrimitive::GLPrimitive() {

	m_material = new GLMaterial();
}

GLPrimitive::~GLPrimitive() {
	if (m_material != NULL)
		delete m_material;
}

GLPrimitive::GLPrimitive(const GLPrimitive& prim) {
	copy(prim);
}

GLPrimitive& GLPrimitive::operator =(const GLPrimitive& prim) {

	if (&prim != this) 
		copy(prim);

	return *this;
}

void GLPrimitive::copy(const GLPrimitive& prim) {

	int i;

	if (m_material != NULL)
		delete m_material;

	m_material = new GLMaterial();

	*m_material = *prim.m_material;
	m_type = prim.m_type;

	for (i = 0; i < m_vertices.size(); i++)
		m_vertices.push_back(prim.m_vertices[i]);
	
}

