#include "stdafx.h"
#include "glpixelshader.h"

GLPixelShader::GLPixelShader() : m_code(NULL) {

}

GLPixelShader::~GLPixelShader() {

	if (m_code != NULL)
		delete [] m_code;
}

void GLPixelShader::enable() {

	nvparse(m_code);
	glEnable(GL_REGISTER_COMBINERS_NV);

}

void GLPixelShader::disable() {

	glDisable(GL_REGISTER_COMBINERS_NV);
}

void GLPixelShader::load(const char* filename) {

	if (strstr(filename,".fsd"))
		loadASMShader(filename);

}

void GLPixelShader::loadASMShader(const char* filename) {
	
	int bytes;
	FILE* file;

	if (NULL == (file = fopen(filename,"rb")))
		throw InvalidShaderException("File Not Found");

	fseek(file,0,SEEK_END);
	bytes = ftell(file);
	rewind(file);

	m_code = new char[bytes+1];
	fread(m_code,1,bytes,file);
	m_code[bytes]='\0';

	fclose(file);
}