#include "stdafx.h"
#include "glmaterial.h"

GLMaterial::GLMaterial() {

}

GLMaterial::GLMaterial(const GLMaterial& mat) {
	copy(mat);
}

GLMaterial& GLMaterial::operator =(const GLMaterial& mat) {

	if (&mat != this) 
		copy(mat);

	return *this;
}

void GLMaterial::copy(const GLMaterial& mat) {

	int i;

	m_textures.clear();

	m_diffuse = mat.m_diffuse;
	m_opacity = mat.m_opacity;
	m_reflectivity = mat.m_reflectivity;
	m_shininess = mat.m_shininess;
	m_specular = mat.m_specular;

	for (i = 0; i < mat.m_textures.size(); i++)
		m_textures.push_back(mat.m_textures[i]);

}

void GLMaterial::bindAll(bool bindarray) {

	bindBase();
	bindTextures(bindarray);

}

void GLMaterial::bindBase() {

	op_float spec[3];

	glColor4f(m_diffuse[0],m_diffuse[1],m_diffuse[2],m_opacity);

	m_specular.getVect(spec);
	glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,spec);
	glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,m_shininess);

}

void GLMaterial::bindTextures(bool bindarray) {

	int start = GL_TEXTURE0_ARB;
	int i;

	for (i = 0; i < m_textures.size(); i++) {
		
		if (m_textures[i] == NULL) {
			start++;
			continue;
		}

		
		if (glActiveTextureARB != NULL) {
			
			glActiveTextureARB(start);

			if (bindarray)
				glClientActiveTextureARB(start);

			start++;
		}

		m_textures[i]->bind();

	}

}

void GLMaterial::unbindTextures(bool bindarray) {

	int start = GL_TEXTURE0_ARB;
	int i;

	for (i = 0; i < m_textures.size(); i++) {
		
		if (m_textures[i] == NULL) {
			start++;
			continue;
		}

		if (glActiveTextureARB != NULL) {
			glActiveTextureARB(start);
			if (bindarray)
				glClientActiveTextureARB(start);

			glDisable(map_to_gl(m_textures[i]->getType()));
			
			start++;
		}
	
	}

}

void GLMaterial::unbindTexture(int index) {

	if (index < 0 || index >= m_textures.size())
		return;

	int texunit = GL_TEXTURE0_ARB+index;
	if (glActiveTextureARB != NULL) {
		glActiveTextureARB(texunit);
		glDisable(map_to_gl(m_textures[index]->getType()));
	}
}