#include "stdafx.h"
#include "gllight.h"

bool GLLight::m_inited=false;
void* GLLight::m_lights[GL_MAX_LIGHTS];

GLLight::GLLight() { 

	int i;
	if (!m_inited) {
		for (i = 0; i < GL_MAX_LIGHTS; i++)
			m_lights[i]=NULL;
		
		m_inited=true;
	}
}

void GLLight::enable() {

	int lightnum;
	op_float ambient[4],diffuse[4],specular[4],position[4];
	op_float spotdir[3];

	m_lightindex = getset_index();
	lightnum = GL_LIGHT0/*+m_lightindex*/;

	glEnable(GL_LIGHTING);

	ambient[0]=m_ambient[0]; ambient[1]=m_ambient[1]; ambient[2]=m_ambient[2]; ambient[3]=1.0f;
	diffuse[0]=m_diffuse[0]; diffuse[1]=m_diffuse[1]; diffuse[2]=m_diffuse[2]; diffuse[3]=1.0f;
	specular[0]=m_specular[0]; specular[1]=m_specular[1]; specular[2]=m_specular[2]; specular[3]=1.0f;
	position[0]=m_position[0]; position[1]=m_position[1]; position[2]=m_position[2];

/*	if (m_model == LIGHT_MODEL_INFINITEVIEWER)
		glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER,GL_FALSE);
	else
		glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER,GL_TRUE);
*/
	if (m_type == LIGHT_TYPE_POINT || m_type == LIGHT_TYPE_SPOT)
		position[3]=1.0;
	else
		position[3]=0.0;

	glLightfv(lightnum,GL_AMBIENT,ambient);
	glLightfv(lightnum,GL_DIFFUSE,diffuse);
	glLightfv(lightnum,GL_SPECULAR,specular);
	glLightfv(lightnum,GL_POSITION,position);

	glLightf(lightnum,GL_CONSTANT_ATTENUATION, m_atten[LIGHT_ATTENUATION_CONSTANT]);
	glLightf(lightnum,GL_LINEAR_ATTENUATION, m_atten[LIGHT_ATTENUATION_LINEAR]);
	glLightf(lightnum,GL_QUADRATIC_ATTENUATION, m_atten[LIGHT_ATTENUATION_QUADRATIC]);

	if (m_type == LIGHT_TYPE_SPOT) {
		spotdir[0]=m_spotdir[0]; spotdir[1]=m_spotdir[1]; spotdir[2]=m_spotdir[2];
		glLightfv(lightnum,GL_SPOT_DIRECTION,spotdir);
		glLightf(lightnum,GL_SPOT_CUTOFF,m_spotcuf);
		glLightf(lightnum,GL_SPOT_EXPONENT,m_spotexp);
	}

	glEnable(lightnum);
}

void GLLight::disable() {

	int i;

	glDisable(GL_LIGHT0+m_lightindex);
	m_lights[m_lightindex]=NULL;

	for (i = 0; i < GL_MAX_LIGHTS; i++)
		if (m_lights[i] != NULL)
			return;

	glDisable(GL_LIGHTING);
}

int GLLight::getset_index() {

	int i;

	for (i = 0; i < GL_MAX_LIGHTS; i++) {
		if (m_lights[i] == NULL) {
			m_lights[i]=(void*)this;
			
			return i;
		}
	}

	return -1;
}