#include "stdafx.h"
#include "glfont.h"

GLFont::GLFont() { 

}

GLFont::~GLFont() {
	SelectObject(m_window->getDeviceContext(),m_hOldFont);
	DeleteObject(m_hFont);
}

void GLFont::enable() {

	glPushAttrib(GL_LIST_BIT);
	
	glListBase(m_listBase);
	glColor4f(m_color[0],m_color[1],m_color[2],1.0f);
}

void GLFont::disable() {

	glPopAttrib();
}

void GLFont::create(const char* face, int height, int style, const Triple& color, Window* window) {

	int bold,italic,underline;

	m_window = (GLWindow*) window;
	m_height = height;

	if ((style & FONT_STYLE_BOLD) == FONT_STYLE_BOLD)
		bold = FW_BOLD;
	else
		bold = FW_NORMAL;

	if ((style & FONT_STYLE_ITALIC) == FONT_STYLE_ITALIC)
		italic = TRUE;
	else
		italic = FALSE;

	if ((style & FONT_STYLE_UNDERLINE) == FONT_STYLE_UNDERLINE)
		underline = TRUE;
	else
		underline = FALSE;

	m_hFont = CreateFont(height,0,0,0,bold,italic,underline,FALSE,ANSI_CHARSET,				
						 OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,ANTIALIASED_QUALITY,FF_DONTCARE | DEFAULT_PITCH,		
						 face);

	m_hOldFont = (HFONT) SelectObject(m_window->getDeviceContext(),m_hFont);

	m_color = color;
	m_listBase = glGenLists(256);

	glColor4f(m_color[0],m_color[1],m_color[2],1.0f);
	wglUseFontBitmaps(m_window->getDeviceContext(),0,255,m_listBase);
}