#include "stdafx.h"
#include "defs.h"

int map_to_gl(int flag) {

	switch (flag) {
	// Texture Types
	case TEXTURE_TYPE_2D:
		return GL_TEXTURE_2D;
	case TEXTURE_TYPE_3D:
		return GL_TEXTURE_3D;
	case TEXTURE_TYPE_2DMIPMAP:
		return GL_TEXTURE_2D;
	case TEXTURE_TYPE_CUBEMAP:
		return GL_TEXTURE_CUBE_MAP_ARB;
	case TEXTURE_TYPE_RENDER:
		return GL_TEXTURE_2D;

	// Texture Wrap Modes
	case TEXTURE_WRAP_REPEAT:
		return GL_REPEAT;
	case TEXTURE_WRAP_CLAMP:
		return GL_CLAMP;
	case TEXTURE_WRAP_EDGECLAMP:
		return GL_CLAMP_TO_EDGE;

	
	//Texture Coord Generation Modes
	case TEXTURE_GEN_SPHEREMAP:
		return GL_SPHERE_MAP;
	case TEXTURE_GEN_OBJECTLINEAR:
		return GL_OBJECT_LINEAR;
	case TEXTURE_GEN_EYELINEAR:
		return GL_EYE_LINEAR;
	case TEXTURE_GEN_CUBEMAP:
		return GL_REFLECTION_MAP_ARB;

	// Texture Combine
	case TEXTURE_COMBINE_MODULATE:
		return GL_MODULATE;
	case TEXTURE_COMBINE_BLEND:
		return GL_BLEND;
	case TEXTURE_COMBINE_DECAL:
		return GL_DECAL;
	case TEXTURE_COMBINE_ADD:
		return GL_ADD;

	// Matrix Modes
	case TRANS_MATRIX_WORLD:
		return GL_MODELVIEW;
	case TRANS_MATRIX_PROJECTION:
		return GL_PROJECTION;
	case TRANS_MATRIX_TEXTURE:
		return GL_TEXTURE;
	case TRANS_MATRIX_COMPOSITE:
		return GL_MODELVIEW_PROJECTION_NV;

	// Vtx Shader Trackers
	case VTXSHADER_TRANS_IDENTITY:
		return GL_IDENTITY_NV;
	case VTXSHADER_TRANS_INVERSE:
		return GL_INVERSE_NV;
	case VTXSHADER_TRANS_INVERSETRANSPOSE:
		return GL_INVERSE_TRANSPOSE_NV;

	// Depth/ZBuffer Masks
	case RND_MASK_LESS:
		return GL_LESS;
	case RND_MASK_LEQUAL:
		return GL_LEQUAL;
	case RND_MASK_GREATER:
		return GL_GREATER;
	case RND_MASK_GEQUAL:
		return GL_GEQUAL;
	case RND_MASK_NEVER:
		return GL_NEVER;
	case RND_MASK_ALWAYS:
		return GL_ALWAYS;
	case RND_MASK_EQUAL:
		return GL_EQUAL;
	case RND_MASK_NEQUAL:
		return GL_NOTEQUAL;

	// Polygon Fill
	case RND_MODE_FILL:
		return GL_FILL;
	case RND_MODE_WIREFRAME:
		return GL_LINE;

	// Shade Model
	case RND_SHADE_FLAT:
		return GL_FLAT;
	case RND_SHADE_GOURAUD:
		return GL_SMOOTH;
	case RND_SHADE_PHONG:
		return GL_SMOOTH;

	// Stencil Action
	case RND_STENCIL_KEEP:
		return GL_KEEP;
	case RND_STENCIL_ERASE:
		return GL_ZERO;
	case RND_STENCIL_REPLACE:
		return GL_REPLACE;
	case RND_STENCIL_INCREMENT:
		return GL_INCR;
	case RND_STENCIL_DECREMENT:
		return GL_DECR;
	case RND_STENCIL_INVERT:
		return GL_INVERT;

	// Blend Factors
	case RND_BLEND_ONE:
		return GL_ONE;
	case RND_BLEND_ZERO:
		return GL_ZERO;
	case RND_BLEND_SRCALPHA:
		return GL_SRC_ALPHA;
	case RND_BLEND_ONEMINUSSRCALPHA:
		return GL_ONE_MINUS_SRC_ALPHA;

	//Prims
	case PRIM_QUAD:
		return GL_QUADS;
	case PRIM_TRIANGLE:
		return GL_TRIANGLES;
	case PRIM_TRIANGLESTRIP:
		return GL_TRIANGLE_STRIP;
	case PRIM_TRIANGLEFAN:
		return GL_TRIANGLE_FAN;
	case PRIM_QUADSTRIP:
		return GL_QUAD_STRIP;
	};

	return 0;
}

