#ifndef __FRUSTUM_H__
#define __FRUSTUM_H__

#include "../optic.h"
#include "defs.h"
#include "vertex.h"

class Frustum {
public:

	Frustum();

	virtual void calcFrustum(const Matrix&, const Matrix&);
	
	virtual bool cullVertex(const Vector&);
	virtual bool cullSphere(const Vector&, op_float);
	virtual bool cullBox(const Vector&, const Vector&);

	virtual void view(op_float,op_float,op_float,op_float,op_float,op_float);
	virtual void view(op_float,op_float,op_float,op_float);

	virtual void enable()=0;

protected:

	op_float m_params[6];
	bool m_angleform;

	Vector m_frustum[6];

};

#endif