#include "frustum.h"

Frustum::Frustum() : m_angleform(true) {

}

void Frustum::calcFrustum(const Matrix& model, const Matrix& proj) {

	Matrix clip(4,4);

	clip = proj * model;

	// Right
	m_frustum[0][0] = clip[3][0]-clip[0][0];
	m_frustum[0][1] = clip[3][1]-clip[0][1];
	m_frustum[0][2] = clip[3][2]-clip[0][2];
	m_frustum[0][3] = clip[3][3]-clip[0][3];
	m_frustum[0] = m_frustum[0].normalize();
	
	// Left
	m_frustum[1][0] = clip[3][0]+clip[0][0];
	m_frustum[1][1] = clip[3][1]+clip[0][1];
	m_frustum[1][2] = clip[3][2]+clip[0][2];
	m_frustum[1][3] = clip[3][3]+clip[0][3];
	m_frustum[1] = m_frustum[1].normalize();
	
	// Bottom
	m_frustum[2][0] = clip[3][0]+clip[1][0];
	m_frustum[2][1] = clip[3][1]+clip[1][1];
	m_frustum[2][2] = clip[3][2]+clip[1][2];
	m_frustum[2][3] = clip[3][3]+clip[1][3];
	m_frustum[2] = m_frustum[2].normalize();
	
	// Top
	m_frustum[3][0] = clip[3][0]-clip[1][0];
	m_frustum[3][1] = clip[3][1]-clip[1][1];
	m_frustum[3][2] = clip[3][2]-clip[1][2];
	m_frustum[3][3] = clip[3][3]-clip[1][3];
	m_frustum[3] = m_frustum[3].normalize();
	
	// Back
	m_frustum[4][0] = clip[3][0]-clip[2][0];
	m_frustum[4][1] = clip[3][1]-clip[2][1];
	m_frustum[4][2] = clip[3][2]-clip[2][2];
	m_frustum[4][3] = clip[3][3]-clip[2][3];
	m_frustum[4] = m_frustum[4].normalize();
	
	// Front
	m_frustum[5][0] = clip[3][0]+clip[2][0];
	m_frustum[5][1] = clip[3][1]+clip[2][1];
	m_frustum[5][2] = clip[3][2]+clip[2][2];
	m_frustum[5][3] = clip[3][3]+clip[2][3];
	m_frustum[5] = m_frustum[5].normalize();
}

bool Frustum::cullBox(const Vector& pos, const Vector& extents) {

	int i;

	for (i = 0; i < 6; i++) {
		
		// Left/Bottom/Back
		if (m_frustum[i][0]*(pos[0]-extents[0]) + m_frustum[i][1]*(pos[1]-extents[1]) + m_frustum[i][2]*(pos[2]-extents[2]) + m_frustum[i][3] > 0)
			continue;
		// Right/Bottom/Back
		if (m_frustum[i][0]*(pos[0]+extents[0]) + m_frustum[i][1]*(pos[1]-extents[1]) + m_frustum[i][2]*(pos[2]-extents[2]) + m_frustum[i][3] > 0)
			continue;
		// Left/Top/Back
		if (m_frustum[i][0]*(pos[0]-extents[0]) + m_frustum[i][1]*(pos[1]+extents[1]) + m_frustum[i][2]*(pos[2]-extents[2]) + m_frustum[i][3] > 0)
			continue;
		// Right/Top/Back
		if (m_frustum[i][0]*(pos[0]+extents[0]) + m_frustum[i][1]*(pos[1]+extents[1]) + m_frustum[i][2]*(pos[2]-extents[2]) + m_frustum[i][3] > 0)
			continue;
		// Left/Bottom/Front
		if (m_frustum[i][0]*(pos[0]-extents[0]) + m_frustum[i][1]*(pos[1]-extents[1]) + m_frustum[i][2]*(pos[2]+extents[2]) + m_frustum[i][3] > 0)
			continue;
		// Right/Bottom/Front
		if (m_frustum[i][0]*(pos[0]+extents[0]) + m_frustum[i][1]*(pos[1]-extents[1]) + m_frustum[i][2]*(pos[2]+extents[2]) + m_frustum[i][3] > 0)
			continue;
		// Left/Top/Front
		if (m_frustum[i][0]*(pos[0]-extents[0]) + m_frustum[i][1]*(pos[1]+extents[1]) + m_frustum[i][2]*(pos[2]+extents[2]) + m_frustum[i][3] > 0)
			continue;
		// Right/Top/Front
		if (m_frustum[i][0]*(pos[0]+extents[0]) + m_frustum[i][1]*(pos[1]+extents[1]) + m_frustum[i][2]*(pos[2]+extents[2]) + m_frustum[i][3] > 0)
			continue;
		
		return true;
	}
	
	return false;
}

bool Frustum::cullSphere(const Vector& center, op_float radius) {

	int i;

	for (i = 0; i < 6; i++ ) {
		if( m_frustum[i][0]*center[0] + m_frustum[i][1]*center[1] + m_frustum[i][2]*center[2] + m_frustum[i][3] <= -radius)
			return true;	
	}

	return false;
}

bool Frustum::cullVertex(const Vector& vertex) {
	
	int i;
	
	for (i = 0; i < 6; i++) {
		if (m_frustum[i][0]*vertex[0] + m_frustum[i][1]*vertex[1] + m_frustum[i][2]*vertex[2] + m_frustum[i][3] <= 0) 
			return true;	
	}
	
	return false;
}

void Frustum::view(op_float fov, op_float aspect, op_float nearp, op_float farp) {
	
	m_angleform = true;
	m_params[0]=fov; m_params[1]=aspect; m_params[2]=nearp; m_params[3]=farp;
}	

void Frustum::view(op_float left, op_float right, op_float bottom, op_float top, op_float nearp, op_float farp) {

	m_angleform = false;
	m_params[0]=left; m_params[1]=right; m_params[2]=bottom; m_params[3]=top;
	m_params[4]=nearp; m_params[5]=farp;
}