#ifndef __FONT_H__
#define __FONT_H__

#include "../optic.h"
#include "defs.h"
#include "window.h"

#define FONT_TYPE_2D			0x1
#define FONT_TYPE_3D			0x2

#define FONT_STYLE_BOLD			0x1
#define FONT_STYLE_ITALIC		0x2
#define FONT_STYLE_UNDERLINE	0x4

class Font {
public:

	Font();

	virtual void enable()=0;
	virtual void disable()=0;

	virtual void create(const char*, int, int, const Triple&,Window*)=0;
	
	virtual int getHeight();
	virtual Triple getColor();

protected:

	Triple m_color;
	int m_height;
};

#endif