#ifndef __FOG_H__
#define __FOG_H__

#include "../optic.h"
#include "defs.h"

#define FOG_TYPE_FAKE			0x1000
#define FOG_TYPE_VOLUMETRIC		0x2000

class Fog {
public:

	Fog();

	virtual void enable()=0;
	virtual void disable()=0;

	virtual void setDensity(op_float);
	virtual void setType(int);
	virtual void setColor(const Triple&);
	virtual void setNear(op_float);
	virtual void setFar(op_float);

	virtual op_float getDensity();
	virtual Triple getColor();
	virtual int getType();
	virtual op_float getNear();
	virtual op_float getFar();

protected:

	int m_type;
	Triple m_color;
	op_float m_density;
	op_float m_near,m_far;
};

#endif