#include "fog.h"

Fog::Fog() { 

	m_color = Vector(0.8f,0.8f,0.8f,1.0f);
	m_density = 0.025f;
	m_type = FOG_TYPE_FAKE;

	m_near=0;
	m_far=50.0;
}

void Fog::setColor(const Triple& color) {
	m_color = color;
}	

void Fog::setDensity(op_float density) {
	m_density = density;
}

void Fog::setType(int type) {
	m_type = type;
}

int Fog::getType() {
	return m_type;
}

op_float Fog::getDensity() {
	return m_density;
}

Triple Fog::getColor() {
	return m_color;
}

op_float Fog::getNear() {
	return m_near;
}

op_float Fog::getFar() {
	return m_far;
}

void Fog::setFar(op_float mfar) {
	m_far = mfar;
}

void Fog::setNear(op_float mnear) {
	m_near = mnear;
}