#ifndef __RENDDEFS_H__
#define __RENDDEFS_H__

#include "../optic.h"

#define RND_NEW2DTEXTURE(_v,_r,_f)		_v = (Texture*) _r->newObject(RND_OBJECT_TEXTURE);\
										_v->create(g_configman->getFile(_f).c_str(),TEXTURE_TYPE_2D);

#define RND_NEW2DMIPTEXTURE(_v,_r,_f)		_v = (Texture*) _r->newObject(RND_OBJECT_TEXTURE);\
										_v->create(g_configman->getFile(_f).c_str(),TEXTURE_TYPE_2DMIPMAP);\
										_v->setFilter(TEXTURE_FILTER_TRILINEAR);

#define RND_NEWPRIMITIVE(_v,_r)			_v = (Primitive*) _r->newObject(RND_OBJECT_PRIMITIVE);

#define RND_NEWVTXSHADER(_v,_r,_f)		_v = (VertexShader*) _r->newObject(RND_OBJECT_VTXSHADER);\
										_v->load(g_configman->getFile(_f).c_str());

#define RND_NEWPIXELSHADER(_v,_r,_f)	_v = (PixelShader*) _r->newObject(RND_OBJECT_PIXELSHADER);\
										_v->load(g_configman->getFile(_f).c_str());

#define RND_NEWVTXARRAY(_v,_r)			_v = (VertexArray*) _r->newObject(RND_OBJECT_VTXARRAY);

// Special
#define RND_DEFAULT					0xDEADC0DE
#define RND_PI						3.1415972
#define RND_TWOPI					6.2831944
#define RND_PIOVER2					1.5707986
#define	RND_DEGTORAD(x)				( ((x) * RND_PI) / 180.0f )

// API List
#define RND_API_OPENGL				0x00000000
#define RND_API_DIRECT3D			0x00000001
#define RND_API_SOFTWARE			0x00000002	

// Fill Mode
#define RND_MODE_FILL				0x10000001
#define RND_MODE_WIREFRAME			0x10000002

// Shade mode
#define RND_SHADE_FLAT				0x20000000
#define RND_SHADE_GOURAUD			0x20000001
#define RND_SHADE_PHONG				0x20000002

// ZBuffer and Stencil Tests
#define RND_MASK_LESS				0x30000000
#define RND_MASK_LEQUAL				0x30000001
#define RND_MASK_GREATER			0x30000002
#define RND_MASK_GEQUAL				0x30000003
#define RND_MASK_NEVER				0x30000004
#define RND_MASK_ALWAYS				0x30000005
#define RND_MASK_EQUAL				0x30000006
#define RND_MASK_NEQUAL				0x30000007

// Stencil Actions
#define RND_STENCIL_KEEP			0x60000000
#define RND_STENCIL_ERASE			0x60000001
#define RND_STENCIL_REPLACE			0x60000002
#define RND_STENCIL_INCREMENT		0x60000003
#define RND_STENCIL_DECREMENT		0x60000004
#define RND_STENCIL_INVERT			0x60000005

// Blend Tests
#define RND_BLEND_ONE				0x40000000
#define RND_BLEND_ZERO				0x40000001
#define RND_BLEND_SRCALPHA			0x40000002
#define RND_BLEND_ONEMINUSSRCALPHA	0x40000003

// Object Types
#define RND_OBJECT_PRIMITIVE		0x50000000
#define RND_OBJECT_MATERIAL			0x50000001
#define RND_OBJECT_LIGHT			0x50000002
#define RND_OBJECT_FRUSTUM			0x50000003
#define RND_OBJECT_TEXTURE			0x50000004
#define RND_OBJECT_TRANSFORMER		0x50000005
#define RND_OBJECT_VIEWER			0x50000006
#define RND_OBJECT_FOG				0x50000007
#define RND_OBJECT_RENDERPROC		0x50000008
#define RND_OBJECT_FONT				0x50000009
#define RND_OBJECT_TEXTURECOMBINER	0x5000000A
#define RND_OBJECT_VTXSHADER		0x5000000B
#define RND_OBJECT_PIXELSHADER		0x5000000C
#define RND_OBJECT_VTXARRAY			0x5000000D

#endif