/** @Description: Global Engine-Wide Definitions, Macros, and Globals
  * @Author: Mike Maxim
*/

#ifndef __OPTIC_H__
#define __OPTIC_H__

#include "support/vector.h"
#include "support/matrix.h"
#include "support/exception.h"
#include "support/logger.h"
#include "support/quaternion.h"
#include "core/configman.h"

#include <cstdio>
#include <cstdlib>
#include <ctime>
#include <vector>
#include <string>
#include <map>
#include <fstream>

#include <windows.h>

#pragma comment(lib, "winmm")
#pragma comment(lib, "kernel32")
#pragma comment(lib, "user32")

#define DIRECTINPUT_VERSION		0x0800

using namespace std;

//Typedefs				
typedef float										op_float;
typedef unsigned char								op_byte;
typedef Vector										Triple;

//Macros
extern string floatTostring(float);
extern string intTostring(int,bool);
extern string toLower(const string&);
extern op_float randomFloat(op_float,op_float);

typedef struct { op_float height; op_float width; } op_rect;

//Defs

// Engine Wide Globals
extern Logger* g_log;
extern ConfigManager* g_configman;


#endif