#include "core/opticengine.h"
#include "cubemapdemo.h"
#include "bumpmapdemo.h"
#include "terraindemo.h"
#include "meshdemo.h"

Logger* g_log;
ConfigManager* g_configman;

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {

	Demo* demo;

	srand(time(NULL));

	g_log = new Logger();
	g_log->enable();
	g_log->open();

	g_configman = new ConfigManager();

	try {
		demo = (Demo*) g_configman->init();
	} catch (Exception e) {
		MessageBox(NULL,e.getMessage().c_str(),"Optic Error",MB_OK | MB_ICONSTOP);
		exit(0);
	}

	g_engine = new OpticEngine();
	g_engine->boot(hInstance,demo);

	return g_engine->mainLoop();
	
}



