#ifndef __MESHDEMO_H__
#define __MESHDEMO_H__

#include "optic.h"
#include "renderer/renderer.h"
#include "core/demo.h"
#include "graphics/skybox.h"
#include "graphics/mesh.h"

#define MESHDEMO_STAGE_GLARE		0x0
#define MESHDEMO_STAGE_ANISO		0x1
#define MESHDEMO_STAGE_BARE			0x2

class MeshDemo : public Demo, public Callback {
public:
	
	MeshDemo();
	
	virtual void init();
	
	virtual void update(op_float);
	virtual void render();
	
	virtual string getName();
	
	virtual void call(HWND,UINT,WPARAM,LPARAM);

private:
	
	void init_graphics();
	void init_input();
	
	Renderer* m_rend;
	Mesh* m_spaceships[4];
	Mesh* m_park,*m_eiffel;
	Vector m_eyepos,m_lightpos;
	VertexShader* m_shader,*m_specshader;
	PixelShader* m_pshader;
	Font* m_font;
	Texture* m_textures[12];
	SkyBox* m_skybox;
	Mesh* m_lsphere;
	
	op_float m_rot,m_lrot;
	int m_rendermode;
	int m_forthrot,m_backthrot,m_w,m_mousepos;

	int m_stage,m_model;
};

#endif