#include "meshdemo.h"

MeshDemo::MeshDemo() : m_eyepos(0,20,-60), m_lightpos(0,50,50), m_rot(0), m_lrot(0), m_stage(MESHDEMO_STAGE_GLARE), m_model(0) {
	m_custrender = true;
}

void MeshDemo::init() {

	Demo::init();

	init_graphics();
	init_input();
}

void MeshDemo::render() {

	m_entman->getGeometry()->render();
	
	m_rend->text(10,20,m_font,"FPS: %.1f",m_timer->getFPS());
	m_rend->text(10,30,m_font,"3DS Mesh Loader");
	m_rend->text(10,40,m_font," w/ Specular Reflection and Anisotropic Lighting Shaders");
	m_rend->text(10,60,m_font,"Hit TAB to switch spaceship");
	m_rend->text(10,70,m_font,"Hit RETURN to switch vertex shader");
	m_rend->text(10,80,m_font,"Use the ARROWS and MOUSE to navigate, the left button switches to wireframe");
	switch (m_stage) {
	case MESHDEMO_STAGE_BARE:
		m_rend->text(10,90,m_font,"Current vertex shader: Basic Phong Lighting");
		break;
	case MESHDEMO_STAGE_GLARE:
		m_rend->text(10,90,m_font,"Current vertex shader: Specular Glare with Reflection Mapping");
		break;
	case MESHDEMO_STAGE_ANISO:
		m_rend->text(10,90,m_font,"Current vertex shader: Anisotropic Lighting");
		break;
	};
}

void MeshDemo::update(op_float dt) {

	if (m_input->pollChannel(m_forthrot).m_button_down[0])
		m_entman->getGeometry()->getViewer()->getCamera()->moveOnView(15.0f*dt);
	if (m_input->pollChannel(m_backthrot).m_button_down[0])
		m_entman->getGeometry()->getViewer()->getCamera()->moveOnView(-15.0f*dt);

	m_rot += 1.0f*dt;
	m_spaceships[m_model]->getOrientation()->translate(Vector(15.0f*cos(m_rot),20,15.0f*sin(m_rot)));
	m_spaceships[m_model]->getOrientation()->rotate_axisangle(Vector(0,1,0).normalize(),80.0f*m_rot);

	m_lrot += 0.5f*dt;
	m_lsphere->getOrientation()->translate(Vector(50.0f*cos(m_lrot),70,50.0f*sin(m_lrot)));

	if (!m_input->pollChannel(m_mousepos).m_button_down[0])
		m_rend->setFillMode(RND_MODE_FILL);
	else
		m_rend->setFillMode(RND_MODE_WIREFRAME);
	
	m_specshader->setConstant(20,m_lsphere->getOrientation()->getPosition());
	m_specshader->setConstant(23,m_entman->getGeometry()->getViewer()->getCamera()->getEyePoint());

}

void MeshDemo::init_graphics() {

	int i;
	BuildParameters* bps[5];
	string ships[] = { "ufo.3ds", "genship.3ds", "spaceship.3ds", "geebee.3ds" };

	ACQUIRE_RENDERER(m_rend,g_engine)
		
	m_entman->getGeometry()->getViewer()->getCamera()->lookat(m_eyepos,Vector(0,10,0),Vector(0,1,0));
	
	m_textures[0] = m_dman->create2DMipmap("ccTerrainmap.tga");
	m_textures[2] = m_dman->create2DMipmap("null_0.tga");
	m_textures[3] = m_dman->create2DMipmap("null_1.tga");
	m_textures[4] = m_dman->create2DMipmap("null_2.tga");
	m_textures[5] = m_dman->create2DMipmap("null_3.tga");
	m_textures[6] = m_dman->create2DMipmap("null_4.tga");
	m_textures[7] = m_dman->create2DMipmap("null_5.tga");
	m_textures[8] = m_dman->create2DMipmap("miors_inv.tga");
	m_textures[9] = m_dman->createCubeMap("c:/optic/data/textures/cubemap/nulltga");
	m_textures[10] = m_dman->create2DMipmap("highlight.tga");
	m_textures[11] = m_dman->create2DMipmap("aniso2.tga");
	
	m_textures[9]->setCombineMode(TEXTURE_COMBINE_MODULATE);
	m_textures[10]->setCombineMode(TEXTURE_COMBINE_ADD);

	// Specular/Cube shader
	m_shader = m_dman->getStoredVertexShader(DMAN_VTXSHADER_BASIC);
	m_specshader = m_dman->getStoredVertexShader(DMAN_VTXSHADER_GLARECUBE);
	m_specshader->setConstant(20,m_lightpos);
	m_specshader->setConstant(21,Vector(0.1f,0.1f,0.1f,0.1f));
	m_specshader->setConstant(23,m_eyepos);
	m_specshader->setConstant(24,Vector(0.5f,0.5f,0.5f,0.5f));

	// Build Ships
	for (i = 0; i < 4; i++) {
		m_spaceships[i] = (Mesh*) m_entman->create("mesh",false);
		bps[1] = new MeshBuildParameters();
		((MeshBuildParameters*)bps[1])->m_filename = g_configman->getFile(ships[i].c_str());
		m_spaceships[i]->setVertexShader(m_specshader);
		m_spaceships[i]->getOrientation()->translate(Vector(0,50,40));
		m_spaceships[i]->getMaterial()->insertTexture(1,m_textures[9]);
		m_spaceships[i]->getMaterial()->insertTexture(2,m_textures[10]);
		m_spaceships[i]->build(bps[1]);	
	}
	m_entman->getGeometry()->insert(m_spaceships[0],true,true);

	// Build Park
	m_park = (Mesh*) (Mesh*) m_entman->create("mesh",false);
	bps[0] = new MeshBuildParameters();
	((MeshBuildParameters*)bps[0])->m_filename = g_configman->getFile("terrain.3ds");
	m_park->setVertexShader(m_shader);
	m_park->build(bps[0]);
	m_entman->getGeometry()->insert(m_park,false,true);

	// Build Sphere
	m_lsphere = (Mesh*) m_entman->create("sphere");
	m_lsphere->getMaterial()->addTexture(m_textures[8]);
	m_lsphere->getMaterial()->addTexture(m_textures[9]);
	m_lsphere->getOrientation()->rotate_axisangle(Vector(1,0,0),180.0f);
	m_lsphere->getOrientation()->scale(Vector(5,5,5));
	m_lsphere->setVertexShader(m_dman->getStoredVertexShader(DMAN_VTXSHADER_CUBEMAPONLY));

	// Build Skybox
	m_skybox = (SkyBox*) m_entman->create("skybox",false);
	m_skybox->getMaterial()->addTexture(m_textures[2]);
	m_skybox->getMaterial()->addTexture(m_textures[3]);
	m_skybox->getMaterial()->addTexture(m_textures[4]);
	m_skybox->getMaterial()->addTexture(m_textures[5]);
	m_skybox->getMaterial()->addTexture(m_textures[6]);
	m_skybox->getMaterial()->addTexture(m_textures[7]);
	bps[2] = new SkyBoxBuildParameters();
	((SkyBoxBuildParameters*)bps[2])->height = 500;
	((SkyBoxBuildParameters*)bps[2])->width = 500;
	((SkyBoxBuildParameters*)bps[2])->depth = 500;
	m_skybox->build(bps[2]);
	m_skybox->getOrientation()->translate(Vector(0,0,0));
	m_entman->getGeometry()->insert(m_skybox,true,false);
	
	m_font = m_dman->getStoredFont(DMAN_FONT_TNR14B);

	m_entman->getGeometry()->compile();
}

void MeshDemo::init_input() {
	
	InputDevice* keyboard,*mouse;
	vector<int> mouse_channels;
	
	keyboard = m_input->getCommonDevice(INPUT_COMMON_KEYBOARD);
	mouse = m_input->getCommonDevice(INPUT_COMMON_MOUSE);
	m_forthrot = m_input->newInputChannel();
	m_backthrot = m_input->newInputChannel(); 
	m_input->addInputChannel(m_forthrot,keyboard,DIK_UP);
	m_input->addInputChannel(m_backthrot,keyboard,DIK_DOWN);
	
	m_input->getChannels(mouse_channels,mouse);
	m_mousepos = mouse_channels[0];
	
	m_entman->getGeometry()->getViewer()->getCamera()->lockToTrackball(m_mousepos);

	m_rend->getWindow()->registerCallback(WM_CHAR,this);
}

string MeshDemo::getName() {
	return "Mesh Loader Demo";
}

void MeshDemo::call(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {

	switch (msg) {
	case WM_CHAR:
		switch (wParam) {
		case VK_RETURN:		
			m_stage = (m_stage+1)%3;
			switch (m_stage) {
			case MESHDEMO_STAGE_GLARE:
				m_spaceships[m_model]->setVertexShader(m_dman->getStoredVertexShader(DMAN_VTXSHADER_GLARECUBE));
				m_spaceships[m_model]->getMaterial()->removeTextures();
				m_spaceships[m_model]->getMaterial()->insertTexture(1,m_textures[9]);
				m_spaceships[m_model]->getMaterial()->insertTexture(2,m_textures[10]);
				break;
			case MESHDEMO_STAGE_ANISO:
				m_spaceships[m_model]->setVertexShader(m_dman->getStoredVertexShader(DMAN_VTXSHADER_ANISO));
				m_spaceships[m_model]->getMaterial()->removeTextures();
				m_spaceships[m_model]->getMaterial()->insertTexture(1,m_textures[11]);
				break;
			case MESHDEMO_STAGE_BARE:
				m_spaceships[m_model]->setVertexShader(m_dman->getStoredVertexShader(DMAN_VTXSHADER_BASIC));
				m_spaceships[m_model]->getMaterial()->removeTextures();
				break;
			};
			break;
		case VK_TAB:
			m_entman->getGeometry()->remove(m_spaceships[m_model]);
			m_model = (m_model+1)%4;
			m_entman->getGeometry()->insert(m_spaceships[m_model],false,true);
			break;
		};
	};
}