#include "mousedevice.h"

MouseInputDevice::MouseInputDevice() : m_lbutton(false), m_rbutton(false), m_mbutton(false) {
	
	m_name = "Mouse";
	m_trackball = true;
	
}

MouseInputDevice::~MouseInputDevice() {
	shutdown();
}

void MouseInputDevice::init(HINSTANCE hInstance, HWND hWnd, LPDIRECTINPUT8 di) {
	
	HRESULT hr;
	DIPROPDWORD dipdw;
	
	m_hWnd = hWnd;
	
	hr = di->CreateDevice(GUID_SysMouse, &m_device, NULL);
	if (FAILED(hr))
		throw InputDeviceFailureException("Could not create mouse object");
	
	hr = m_device->SetDataFormat(&c_dfDIMouse);
	if (FAILED(hr)) {
		shutdown();
		throw InputDeviceFailureException("Could not set mouse data format");
	}
	
	hr = m_device->SetCooperativeLevel(hWnd,DISCL_EXCLUSIVE | DISCL_FOREGROUND);
	if (FAILED(hr)) {
		shutdown();
		throw InputDeviceFailureException("Could not coorperate with Windows");
	}
	
    dipdw.diph.dwSize       = sizeof(DIPROPDWORD);
    dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
    dipdw.diph.dwObj        = 0;
    dipdw.diph.dwHow        = DIPH_DEVICE;
    dipdw.dwData            = 16;
	hr = m_device->SetProperty(DIPROP_BUFFERSIZE, &dipdw.diph);
	if (FAILED(hr)) {
		shutdown();
		throw InputDeviceFailureException("Could not set mouse buffer");
	}
	
	m_device->Acquire();
}

void MouseInputDevice::shutdown() {

	if (m_device != NULL) { 	
		m_device->Unacquire(); 
		m_device->Release();
		m_device = NULL; 		
	}  
}

InputDeviceStatus MouseInputDevice::getStatus(int code) {
	
	InputDeviceStatus status;
	
	status.m_trackposition = m_position;
	status.m_button_down[0] = m_lbutton;
	status.m_button_down[1] = m_mbutton;
	status.m_button_down[2] = m_rbutton;
	
	return status;
}

void MouseInputDevice::update() {
	
	InputDeviceStatus status;
	DIDEVICEOBJECTDATA od;
	HRESULT hr;
	DWORD dwElements;
	bool done=false;

	while (!done) {
		
		dwElements = 1;
		hr = m_device->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),&od, &dwElements, 0);
		if (FAILED(hr) || dwElements == 0)
			break;
		
		switch (od.dwOfs) {
		case DIMOFS_X: 	
			update_curs(od.dwData,0);
			break;
		case DIMOFS_Y: 
			update_curs(od.dwData,1);
			break; 
		case DIMOFS_BUTTON0:	
			done = true;
			if (od.dwData & 0x80) 
				m_lbutton = true;
			else
				m_lbutton = false;
			break;
		case DIMOFS_BUTTON1:		
			done = true;
			if (od.dwData & 0x80)
				m_rbutton = true;
			else
				m_rbutton = false;
			break;	
		};

	}

}

void MouseInputDevice::execute(int command, const vector<void*>& params) {

	switch (command) {
	case INPUT_MOUSE_EXECUTE_SETPOSITION:
		m_position = *((Vector*) params[0]);
		break;
		
	};
}

void MouseInputDevice::update_curs(unsigned long data, int index) {
	
	RECT r;

	GetWindowRect(m_hWnd,&r);

	m_position[index] += (int)data;

	if (index == 0) {
		if (m_position[index] < 0)
			m_position[index] = 0;
		if (m_position[index] > r.right)
			m_position[index] = r.right-1;
	}
	else {
		if (m_position[index] < r.top)
			m_position[index] = r.top+1;
		if (m_position[index] > r.bottom)
			m_position[index] = r.bottom-1;
	}
}
