#include "kbdevice.h"

KeyboardInputDevice::KeyboardInputDevice() {

	m_name = "Keyboard";
	m_trackball = false;
}

KeyboardInputDevice::~KeyboardInputDevice() {
	shutdown();
}

void KeyboardInputDevice::init(HINSTANCE hInstance, HWND hWnd, LPDIRECTINPUT8 di) {
	
	HRESULT hr;
	
	hr = di->CreateDevice(GUID_SysKeyboard, &m_device, NULL); 
	if (FAILED(hr))
		throw InputDeviceFailureException("Keyboard: Could not init device");
	
	hr = m_device->SetDataFormat(&c_dfDIKeyboard);
	if (FAILED(hr)) {
		shutdown();
		throw InputDeviceFailureException("Keyboard: Could not set data format");
	}
	
	hr = m_device->SetCooperativeLevel(hWnd, DISCL_FOREGROUND | DISCL_NONEXCLUSIVE); 
	if (FAILED(hr)) {
		shutdown();
		throw InputDeviceFailureException("Keyboard: Could not coorperate with Windows");
	}
	
	acquire();
}

void KeyboardInputDevice::shutdown() {
			
	if (m_device != NULL) { 	
		m_device->Unacquire(); 
		m_device->Release();
		m_device = NULL; 		
	}   	
}

void KeyboardInputDevice::update() {

}

InputDeviceStatus KeyboardInputDevice::getStatus(int key) {
	
	HRESULT hr;
	InputDeviceStatus ids;
	char buffer[256];
	
	hr = m_device->GetDeviceState(sizeof(buffer),(void*)&buffer);
	if (FAILED(hr)) {
		if (hr == DIERR_INPUTLOST)
		m_device->Acquire();
	}
	ids.m_button_down[0] = (INP_KEYDOWN(buffer,key));
	
	return ids;
}

void KeyboardInputDevice::execute(int command, const vector<void*>& params) {

}