#ifndef __INPUT_H__
#define __INPUT_H__

#include "../optic.h"
#include "device.h"
#include "kbdevice.h"
#include "mousedevice.h"

#define	INPUT_COMMON_KEYBOARD		0x1
#define INPUT_COMMON_MOUSE			0x2

typedef	int		op_inphnd;

class InputSubsystemException : public Exception {
public:

	InputSubsystemException() : Exception("Unable to start the input subsystem") { }
	InputSubsystemException(const string& s) : Exception ("Unable to start the input subsystem: " + s) { }

};

class InputChannelEntry {
public:

	InputChannelEntry() { }

	InputDevice* m_device;
	int m_devicecode;

};

class InputManager {
public:

	InputManager();
	virtual ~InputManager();

	void init(HINSTANCE,HWND);
	void shutdown();
	void updateDevices();
	void reacquireDevices();

	InputDevice* getCommonDevice(int);
	void getChannels(vector<int>&,InputDevice*);

	op_inphnd newInputChannel();
	void addInputChannel(op_inphnd,InputDevice*,int);
	InputDeviceStatus pollChannel(op_inphnd);
	void executeOverChannel(op_inphnd,int,const vector<void*>&);

	void EnumerateDevices(vector<InputDevice*>&);
	
private:

	vector< vector<InputChannelEntry> > m_inpchannels;
	vector<InputDevice*> m_devices;
	HINSTANCE m_hInstance;
	LPDIRECTINPUT8 m_di;
};

#endif