#include "input.h"

InputManager::InputManager() {

}

InputManager::~InputManager() {
	shutdown();
}

void InputManager::init(HINSTANCE hInstance, HWND hWnd) {

	HRESULT hr;
	InputDevice* id;
	int chan;

	//Start up the DI8
	hr = DirectInput8Create(hInstance, DIRECTINPUT_VERSION, IID_IDirectInput8, (void**)&m_di, NULL);
	if (FAILED(hr)) 
		throw InputSubsystemException("Object creation failure for DI8");

	// Get the keyboard
	id = new KeyboardInputDevice();
	try {
		id->init(hInstance,hWnd,m_di);
		m_devices.push_back(id);
	}
	catch (Exception e) { MessageBox(NULL,e.getMessage().c_str(),"Help!",MB_OK | MB_ICONSTOP); }

	// Get the mouse
	id = new MouseInputDevice();
	try {
		id->init(hInstance,hWnd,m_di);
		chan = newInputChannel();
		addInputChannel(chan,id,0);
		m_devices.push_back(id);
	}
	catch (Exception e) { MessageBox(NULL,e.getMessage().c_str(),"Help!",MB_OK | MB_ICONSTOP); }
	
}

void InputManager::shutdown() {

	int i;
	for (i = 0; i < m_devices.size(); i++)
		delete m_devices[i];

	m_devices.clear();
	m_inpchannels.clear();

	if (m_di != NULL) {
		m_di->Release();
		m_di = NULL;
	}
}

void InputManager::updateDevices() {

	int i;
	for (i = 0; i < m_devices.size(); i++)
		m_devices[i]->update();
}

void InputManager::reacquireDevices() {

	int i;
	for (i = 0; i < m_devices.size(); i++)
		m_devices[i]->acquire(true);
}

op_inphnd InputManager::newInputChannel() {

	vector<InputChannelEntry> icelist;

	m_inpchannels.push_back(icelist);

	return (m_inpchannels.size()-1);
}

void InputManager::addInputChannel(op_inphnd channel, InputDevice* device, int code) {

	InputChannelEntry ice;

	ice.m_device = device;
	ice.m_devicecode = code;

	m_inpchannels[channel].push_back(ice);
}

InputDeviceStatus InputManager::pollChannel(op_inphnd channel) {

	int i;
	InputDeviceStatus status;
	InputChannelEntry curchannel;

	if (m_inpchannels[channel].size() > 0 && m_inpchannels[channel][0].m_device->isTrackball()) 
		return m_inpchannels[channel][0].m_device->getStatus(0);
	
	for (i = 0; i < m_inpchannels[channel].size(); i++) {

		curchannel = m_inpchannels[channel][i];
		status = curchannel.m_device->getStatus(curchannel.m_devicecode);

		if (status.m_button_down)
			return status;
	}

	return InputDeviceStatus();
}

void InputManager::executeOverChannel(op_inphnd channel, int command, const vector<void*>& params) {
	
	int i;
	for (i = 0; i < m_inpchannels[channel].size(); i++)
		m_inpchannels[channel][i].m_device->execute(command,params);

}

void InputManager::EnumerateDevices(vector<InputDevice*>& devices) {

	int i;
	for (i = 0; i < m_devices.size(); i++)
		devices.push_back(m_devices[i]);
}

InputDevice* InputManager::getCommonDevice(int type) {

	int i;

	if (type == INPUT_COMMON_KEYBOARD) {
		for (i = 0; i < m_devices.size(); i++)
			if (m_devices[i]->getName() == "Keyboard")
				return m_devices[i];
	}
	else if (type == INPUT_COMMON_MOUSE) {
		for (i = 0; i < m_devices.size(); i++)
			if (m_devices[i]->getName() == "Mouse")
				return m_devices[i];
	}

	return NULL;
}

void InputManager::getChannels(vector<int>& channels, InputDevice* device) {

	int i,j;
	for (i = 0; i < m_inpchannels.size(); i++) {
		for (j = 0; j < m_inpchannels[i].size(); j++) {
			if (m_inpchannels[i][j].m_device == device)
				channels.push_back(i);
		}
	}

}