#ifndef __DEVICE_H__
#define __DEVICE_H__

#include "../optic.h"
#include <dx81sdk/include/dinput.h>

#pragma comment(lib, "dinput8")
#pragma comment(lib, "dxguid")

class InputDeviceFailureException : public Exception {
public:

	InputDeviceFailureException() : Exception("Input Device Unavailable") { }
	InputDeviceFailureException(const string& s) : Exception("Input Device Unavailble: " + s) { }

};

class InputDeviceStatus {
public:
	
	InputDeviceStatus() { m_button_down[0] = m_button_down[1] = m_button_down[2] = false; }

	bool m_button_down[3];
	Vector m_trackposition,m_trackvelocity,m_trackacceleration;
};

class InputDevice {
public:

	InputDevice();

	virtual void init(HINSTANCE,HWND,LPDIRECTINPUT8)=0;
	virtual void shutdown()=0;
	virtual void update()=0;
	virtual void acquire(bool force = false);
	virtual void unacquire();
	virtual void execute(int,const vector<void*>&)=0;

	virtual InputDeviceStatus getStatus(int)=0;

	virtual string getName();
	virtual bool isTrackball();

protected:

	LPDIRECTINPUTDEVICE8 m_device;
	string m_name;
	bool m_trackball,m_acquired;
};

#endif