#include "device.h"

InputDevice::InputDevice() : m_acquired(false), m_device(NULL) {

}

void InputDevice::acquire(bool force) {
	if (!m_acquired || force) {
		m_acquired = true;
		m_device->Acquire();
	}
}	

void InputDevice::unacquire() {
	if (m_acquired) {
		m_acquired = false;
		m_device->Unacquire();
	}
}

string InputDevice::getName() {
	return m_name;
}

bool InputDevice::isTrackball() {
	return m_trackball;
}