
/* 
 * The following macro invocations define error codes returned by various cg 
 * API functions.
 *
 * The macros have the form :
 *
 *   CG_ERROR_MACRO(code, enum_name, message)
 *
 *     code      : The integer error code associated with the error.
 *     enum_name : The name of enumerant of the error code.  
 *                  (Note : the prefix "cg" will be added to the name).
 *     message   : A description string associated with the error.
 *   
 */


CG_ERROR_MACRO(0, 
               NoError,
               "No error has occurred.")

CG_ERROR_MACRO(1, 
               CompileError, 
               "The compile returned an error.")

CG_ERROR_MACRO(2, 
               InvalidParameterError,
               "The parameter used is of invalid type.")

CG_ERROR_MACRO(3, 
               InvalidProfileError, 
               "The profile is not supported.")

CG_ERROR_MACRO(4, 
               ProgramLoadError,
               "The program did could not load.")

CG_ERROR_MACRO(5, 
               ProgramBindError, 
               "The program could not bind.")

CG_ERROR_MACRO(6, 
               ProgramNotLoadedError,
               "The program must be loaded before this operation may be used.")

CG_ERROR_MACRO(7, 
               UnsupportedGLExtensionError,
               "An unsupported GL extension was required to perform this operation.")

CG_ERROR_MACRO(8, 
               InvalidValueTypeError,
               "An unknown value type was assigned to a parameter.")

CG_ERROR_MACRO(9, 
               NotMatrixParamError,
               "The parameter is not of matrix type.")

CG_ERROR_MACRO(10, 
               InvalidEnumerantError,
               "The enumerant parameter has an invalid value.")

CG_ERROR_MACRO(11, 
               Not4x4MatrixError,
               "The parameter must be a 4x4 matrix type.")

#undef CG_ERROR_MACRO

