#ifndef _cggl_h
#define _cggl_h

#include <Cg/cg.h>


#if WIN32
# include <windows.h>
#endif

#include <GL/gl.h>

#define GLH_EXT_SINGLE_FILE
#define GL_ARB_MULTITEXTURE
#include <GL/glext.h>

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************/
/*** cgGL Type Definitions                                                 ***/
/*****************************************************************************/

typedef enum 
 {
  cgGLMatrixIdentity = 0,
  cgGLMatrixTranspose = 1,
  cgGLMatrixInverse = 2,
 } cgGLMatrixFormat;

typedef enum 
 {
  cgGLModelViewMatrix,
  cgGLProjectionMatrix,
  cgGLTextureMatrix,
  cgGLModelViewProjectionMatrix,
 } cgGLMatrixType;

/*****************************************************************************/
/*** Program Loading and Binding Functions                                 ***/
/*****************************************************************************/

extern cgError cgGLLoadProgram(cgProgramIter *program, GLuint prog_id);
extern cgError cgGLBindProgram(cgProgramIter *program);

extern cgError cgGLEnableProgramType(cgProfileType profile);
extern cgError cgGLDisableProgramType(cgProfileType profile);

/*****************************************************************************/
/*** Texture Unit Identifier Functions                                     ***/
/*****************************************************************************/

extern GLenum cgGLTextureUnit(const cgBindIter *param);
extern cgError cgGLActiveTexture(const cgBindIter *param);
extern cgError cgGLActiveClientTexture(const cgBindIter *param);

/*****************************************************************************/
/*** Uniform Parameter Binding Functions                                   ***/
/*****************************************************************************/

extern cgError cgGLBindUniform4f(cgProgramIter *program,
                                   cgBindIter *param, 
		                   float x,
		                   float y,
		                   float z,
		                   float w);

extern cgError cgGLBindUniform4d(cgProgramIter *program,
                                   cgBindIter *param, 
		                   double x,
		                   double y,
		                   double z,
		                   double w);

extern cgError cgGLBindUniform4fv(cgProgramIter *program,
                                    cgBindIter *param, 
                                    const float v[]); 

extern cgError cgGLBindUniform4dv(cgProgramIter *program,
                                    cgBindIter *param, 
                                    const double v[]); 

extern cgError cgGLBindUniformMatrixrf(cgProgramIter *program,
                                       cgBindIter *param, 
                                       const float *matrix);

extern cgError cgGLBindUniformMatrixrd(cgProgramIter *program,
                                       cgBindIter *param, 
                                       const double *matrix);

extern cgError cgGLBindUniformMatrixcf(cgProgramIter *program,
                                       cgBindIter *param, 
                                       const float *matrix);

extern cgError cgGLBindUniformMatrixcd(cgProgramIter *program,
                                       cgBindIter *param, 
                                       const double *matrix);

extern cgError cgGLBindUniformStateMatrix(cgProgramIter *program,
                                          cgBindIter *param,
                                          cgGLMatrixType matrix_type,
                                          int format);

/*****************************************************************************/
/*** Varying Parameter Binding Functions                                   ***/
/*****************************************************************************/

extern cgError cgGLEnableClientState(cgProgramIter *program,
                                     cgBindIter *param);

extern cgError cgGLDisableClientState(cgProgramIter *program,
                                      cgBindIter *param);

extern cgError cgGLBindVaryingPointer(cgProgramIter *program,
                                      cgBindIter *param,
                                      GLint fsize,
                                      GLenum type,
                                      GLsizei stride,
                                      GLvoid *pointer);

extern cgError cgGLBindVarying1s(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLshort x);

extern cgError cgGLBindVarying1f(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLfloat x);

extern cgError cgGLBindVarying1d(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLdouble x);

extern cgError cgGLBindVarying2s(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLshort x,
                                 GLshort y);

extern cgError cgGLBindVarying2f(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLfloat x,
                                 GLfloat y);

extern cgError cgGLBindVarying2d(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLdouble x,
                                 GLdouble y);

extern cgError cgGLBindVarying3s(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLshort x,
                                 GLshort y,
                                 GLshort z);

extern cgError cgGLBindVarying3f(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLfloat x,
                                 GLfloat y,
                                 GLfloat z);

extern cgError cgGLBindVarying3d(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLdouble x,
                                 GLdouble y,
                                 GLdouble z);

extern cgError cgGLBindVarying4s(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLshort x,
                                 GLshort y,
                                 GLshort z,
                                 GLshort w);

extern cgError cgGLBindVarying4f(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLfloat x,
                                 GLfloat y,
                                 GLfloat z,
                                 GLfloat w);

extern cgError cgGLBindVarying4d(cgProgramIter *program,
                                 cgBindIter *param,
                                 GLdouble x,
                                 GLdouble y,
                                 GLdouble z,
                                 GLdouble w);

extern cgError cgGLBindVarying4ub(cgProgramIter *program,
                                  cgBindIter *param,
                                  GLubyte x,
                                  GLubyte y,
                                  GLubyte z,
                                  GLubyte w);

extern cgError cgGLBindVarying1sv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLshort *v);

extern cgError cgGLBindVarying1fv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLfloat *v);

extern cgError cgGLBindVarying1dv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLdouble *v);

extern cgError cgGLBindVarying2sv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLshort *v);

extern cgError cgGLBindVarying2fv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLfloat *v);

extern cgError cgGLBindVarying2dv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLdouble *v);

extern cgError cgGLBindVarying3sv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLshort *v);

extern cgError cgGLBindVarying3fv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLfloat *v);

extern cgError cgGLBindVarying3dv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLdouble *v);

extern cgError cgGLBindVarying4sv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLshort *v);

extern cgError cgGLBindVarying4fv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLfloat *v);

extern cgError cgGLBindVarying4dv(cgProgramIter *program,
                                  cgBindIter *param,
                                  const GLdouble *v);

extern cgError cgGLBindVarying4ubv(cgProgramIter *program,
                                   cgBindIter *param,
                                   const GLubyte *v);


#ifdef __cplusplus
}
#endif

#endif
