#ifndef _cgD3D_h
#define _cgD3D_h

#include <Cg/cg.h>
#include <assert.h>


#ifndef STRICT
#define STRICT
#endif

#include <windows.h>
#include <commdlg.h>
#include <tchar.h>
#include <stdio.h>
#include <d3d8.h>
#include <d3dx8.h>


#define MAX_STREAMS 16

#include <Cg/cgProgramManager.h>
#include <Cg/cgContextManager.h>
           



////////////////////////////////////////////////
//
//	cgDX8Vertex  and cgDX8Pixel are defined with
//  macros:
//
//	CG_PROFILE_MACRO(DX8Vertex,dx8vs,"dx8vs")
//	CG_PROFILE_MACRO(DX8Pixel,dx8ps,"dx8ps")
//
//	cgDX8VertexProfile




class cgDirect3D
{
public:

    cgDirect3D();
    ~cgDirect3D();

    // add a path to locate the cg programs
    // do not add the trailing '\\'
    void AddFilePath(const char * dirpath);
    void AddFilePath(std::string & path);
     
    
    void NotePad(const char * title, const char * listing )
    {
        
        std::string text;
        text = title;
        text += listing;
        
        char * TmpLstFile = tmpnam(0);
        
        FILE * fpLst = fopen(TmpLstFile, "w");
        fputs(text.c_str(), fpLst);
        fclose(fpLst);
        
        char Cmd[1000];
        sprintf(Cmd, "notepad %s", TmpLstFile);
        int Ret =  system(Cmd);
        
        unlink(TmpLstFile);
        
    }

    cgContextContainer * CreateContextContainer(LPDIRECT3DDEVICE8 pd3dDevice, DWORD * outIndex = 0)
    {
        return cm.CreateContextContainer(pd3dDevice,  outIndex);
    }
    

private:
    cgContextManager cm;
    LPDIRECT3DDEVICE8 m_pd3dDevice;

};
                            








#define CGRTERR_ILLEGAL_PROFILE -1
#define CGRTERR_VERTEX_ATTRIBUTES_NOT_SET -2

#endif

