/*********************************************************************NVMH2****
File:  cgContextManager.h

Copyright (C) 1999, 2000 NVIDIA Corporation
This file is provided without support, instruction, or implied warranty of any
kind.  NVIDIA makes no guarantee of its fitness for a particular purpose and is
not liable under any circumstances for any damages or loss whatsoever arising
from the use or inability to use this file or items derived from it.

Comments:

cgContextManager - a class for loading various cg programs,


******************************************************************************/



#ifndef __NV_CG_MANAGER_H
#define	__NV_CG_MANAGER_H


#pragma warning (disable:4786) // identifier was truncated to '255' characters in the browser information

#include <windows.h>
#include <d3d8.h>
#include <d3dx8.h>
#include <vector>

#include <string>
#include <Cg/cg.h>

#include <Cg/cgProgramManager.h>


 



class cgContextManager;


class cgContextContainer
{
public:


    // retrieve the listing file for the last compile
    const char *GetLastListing();


    // loads and compiles the cg program
    cgProgramContainer * LoadCGProgramFromFile(
        const char * filename,           // filename of the Cg program
        const char * title,               // title of the program                               
        cgProfileType type,       // profile of the program                            
        cgVertexAttribute * va = 0, // optionally, set streams or allow different vetex definitions
        DWORD * outIndex = 0,
        const char * entry = 0);

    cgProgramContainer *  LoadCGProgramFromMemory(
        const char * memory,          // memory location that contain the cg program 
        const char * title,            // name of the program 
        cgProfileType type,    // profile of the program
        cgVertexAttribute * va = 0,   // optionally, set the streams for each vertex entry
        DWORD * outIndex = 0,
        const char * entry = 0);


    // use outIndex returned from LoadCGProgramFrom to retriece the program iterator
    cgProgramContainer * GetProgramIterator(DWORD index);


    // program operators (for multiple programs(vertex, pixel) in one cg
    // pass NULL to get first program
    cgProgramIter *GetNextProgram(cgProgramIter *iter);

    // get a specific program
    cgProgramIter *ProgramByName(const char *name);


    // get the vertexshader or pixel shader handle that is passed to 
    // SetVertexShader and SetPixelShader
    DWORD GetShaderHandle(cgProfileType type)
    {
        return pm.GetShaderHandle( type);
    }

    ~cgContextContainer( );

    friend class cgContextManager;
protected:

    cgContextContainer( LPDIRECT3DDEVICE8 pd3dDevice, cgContext * context);


private:


    cgProgramContainer * CreateProgramContainer(DWORD * outIndex = 0);

    cgProgramContainer * CreateProgramContainer( 
        cgProgramIter *ProgramIter, 
        LPDIRECT3DDEVICE8 pd3dDevice, 
        DWORD * outIndex = 0);       // index of this 

    // loads and compiles the cg program
    HRESULT AddProgramFromFile(const char * filename, const char * name, cgProfileType type, const char * entry = 0);
    HRESULT AddProgramFromMemory(const char * memory, const char * name, cgProfileType type, const char * entry = 0);


    void Free();
    cgProgramManager pm; // manage the vertex or pixel shader that is derived from this
    cgContext * m_Context;
    std::string		m_ContextDefinition;
    LPDIRECT3DDEVICE8 m_pd3dDevice;

};



class cgContextManager
{
private:

	std::vector < cgContextContainer *>	m_ContextContainers;		
	std::vector < DWORD >		        m_ContextIndices;	// indirection to m_Shaders
											// Programs hold an index to this array for
											// their shaders.  The array int at that index
											// holds the index into the m_Shaders array.

    // each context has a list of programs (up to one for each profile)


public:
	cgContextManager();
	~cgContextManager();

	cgError Free();

    cgContextContainer  *CreateContextContainer(LPDIRECT3DDEVICE8 pd3dDevice, DWORD * outIndex);
    cgContextContainer  *CreateContextContainer(DWORD outIndex);



};


#endif			


