#ifndef _cg_h
#define _cg_h

/*************************************************************************/
/*** CG Run-Time Library API                                          ***/
/*************************************************************************/

/*************************************************************************/
/*** Data types and structures                                         ***/
/*************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
 {
# define CG_ERROR_MACRO(code, enum_name, message) \
   cg##enum_name = code,
# include <Cg/cg_errors.h>
 } cgError;

typedef struct
 {
  /* Opaque structure */
  void *Data;
 } cgContext;

typedef struct
 {
  /* Opaque structure */
  void *Data;
 } cgProgramIter;

typedef struct
 {
  /* Opaque structure */
  void *Data;
 } cgBindIter;

typedef enum
 {
# define CG_DATATYPE_MACRO(name, compiler_name, ncols, nrows) \
  cg##name##ValueType,

#include <Cg/cg_datatypes.h>

  cgUnknownValueType
 } cgValueType;

typedef enum
 {
  cgConstParam,
  cgUniformParam,
  cgConnectorMemberParam,
  cgTexObjParam,
  cgAnyParam,
  cgUndefinedParam,
 } cgParamType;

typedef enum
 {
  cgBindTex0 = 0,
  cgBindTex1 = 1,
  cgBindTex2 = 2,
  cgBindTex3 = 3,
  cgBindTex4 = 4,
  cgBindTex5 = 5,
  cgBindTex6 = 6,
  cgBindTex7 = 7,

  cgBindAttr0,
  cgBindAttr1,
  cgBindAttr2,
  cgBindAttr3,
  cgBindAttr4,
  cgBindAttr5,
  cgBindAttr6,
  cgBindAttr7,
  cgBindAttr8,
  cgBindAttr9,
  cgBindAttr10,
  cgBindAttr11,
  cgBindAttr12,
  cgBindAttr13,
  cgBindAttr14,
  cgBindAttr15,

  cgBindVertUniform,

  cgBindUndefined
 } cgBindLocation;


typedef enum
 {
# define CG_PROFILE_MACRO(name, compiler_id, compiler_opt) \
   cg##name##Profile,
# include "Cg/cg_profiles.h"

  cgNProfiles,
  cgUnknownProfile,
 } cgProfileType;

/*************************************************************************/
/*** Function Prototypes                                               ***/
/*************************************************************************/


/*******************************************************************/
/*** cg Misc Functions                                         ****/
/*******************************************************************/

extern void cgCleanup(void);

/* This will probably be deprecated in future releases */
extern void cgSetCompilerExe(const char *exe);

extern const char *cgErrorMsg(cgError error);

/*******************************************************************/
/*** cgContext Functions                                       ****/
/*******************************************************************/

extern cgContext *cgCreateContext(void);

extern void cgFreeContext(cgContext *context);

extern cgError cgAddProgram(cgContext *context,
                              const char *text,
                              cgProfileType profile,
                              const char *entry);

extern cgError cgAddProgramFromFile(cgContext *context,
                              const char *filename,
                              cgProfileType profile,
                              const char *entry);


extern const char *cgGetLastListing(cgContext *context);

/*******************************************************************/
/*** cgProgram Functions                                        ***/
/*******************************************************************/

extern cgProgramIter *cgGetNextProgram(cgContext *context,
                                         cgProgramIter *iter);

extern cgProgramIter *cgProgramByName(cgContext *context, 
                                        const char *name);

extern void cgFreeProgramIter(cgProgramIter *program);

extern cgProgramIter *cgDuplicateProgram(cgProgramIter *program);

extern const char *cgGetProgramName(const cgProgramIter *program);

extern cgProfileType cgGetProgramProfile(const cgProgramIter *program);

extern const char *cgGetProgramObjectCode(const cgProgramIter *program);



/*******************************************************************/
/*** Parameter and Binding Functions                            ****/
/*******************************************************************/

extern cgBindIter *cgGetNextBind(cgProgramIter *program,
                                   cgBindIter *iter);

extern cgBindIter *cgGetBindByName(cgProgramIter *program, 
                                     const char *parameter_name);

extern cgFreeBindIter(cgBindIter *iter);

extern const char *cgGetBindParamName(const cgBindIter *bind);

extern cgParamType cgGetBindParamType(const cgBindIter *bind);

extern cgBindLocation cgGetBindLocation(const cgBindIter *bind);

extern cgValueType cgGetBindValueType(const cgBindIter *bind,
                                      int *array_size);

#ifdef __cplusplus
}
#endif


#endif
