#ifndef __GRID_H__
#define __GRID_H__

#include "optic.h"
#include "core/opticengine.h"
#include "renderer/renderer.h"

class Grid {
public:
	
	Grid();

	virtual void build(op_float,op_float,int);
	
	virtual void addTexture(Texture*);
	virtual void setVertexShader(VertexShader*);
	virtual void setTextureCombiner(TextureCombiner*);
	virtual Material* getMaterial();

	virtual void render();

private:
	
	VertexShader* m_shader;
	TextureCombiner* m_texcombiner;

	Material* m_material;
	vector<Texture*> m_textures;
	op_float m_width,m_height,m_tess;

	vector<Primitive*> m_rows;

	Renderer* m_rend;
};

#endif