#ifndef __TORUS_H__
#define __TORUS_H__

#include "../optic.h"
#include "../core/opticengine.h"
#include "../renderer/renderer.h"

class Torus {
public:

	Torus();

	virtual void build(op_float,op_float,int,int);
	
	virtual void setVertexShader(VertexShader*);
	virtual void setTextureCombiner(TextureCombiner*);
	virtual Material* getMaterial();

	virtual void render();

private:

	Material* m_material;
	VertexShader* m_vtxshader;
	TextureCombiner* m_texcombiner;

	Renderer* m_rend;
	RenderProc* m_rendproc;

};

#endif