#include "Torus.h"

Torus::Torus() : m_texcombiner(NULL), m_vtxshader(NULL), m_rendproc(NULL) {
	
	m_rend = (Renderer*) g_engine->getSubSystem(OPTIC_SUBSYS_RENDERER);

	m_material = (Material*) m_rend->newObject(RND_OBJECT_MATERIAL);
	m_rendproc = (RenderProc*) m_rend->newObject(RND_OBJECT_RENDERPROC);
}

void Torus::build(op_float r, op_float R, int nsides, int rings) {
	
	int i,j;
	Primitive* prim;
	Vertex vert;	
	op_float theta, phi, theta1;
	op_float cosTheta, sinTheta;
	op_float cosTheta1, sinTheta1;
	op_float ringDelta, sideDelta;

	prim = (Primitive*) m_rend->newObject(RND_OBJECT_PRIMITIVE);
	prim->setType(PRIM_QUADSTRIP);
	prim->setMaterial(m_material);
	
	ringDelta = RND_TWOPI / rings;
	sideDelta = RND_TWOPI / nsides;
	
	theta = 0.0;
	cosTheta = 1.0;
	sinTheta = 0.0;
	for (i = rings - 1; i >= 0; i--) {
		theta1 = theta + ringDelta;
		cosTheta1 = cos(theta1);
		sinTheta1 = sin(theta1);
		phi = 0.0;
		for (j = nsides; j >= 0; j--) {
			op_float cosPhi, sinPhi, dist;
			
			phi += sideDelta;
			cosPhi = cos(phi);
			sinPhi = sin(phi);
			dist = R + r * cosPhi;
			
			vert.m_normal = Vector(cosTheta1 * cosPhi, -sinTheta1 * cosPhi, sinPhi);
			vert.m_position = Vector(cosTheta1 * dist, -sinTheta1 * dist, r * sinPhi);
			prim->addVertex(vert);

			vert.m_normal = Vector(cosTheta * cosPhi, -sinTheta * cosPhi, sinPhi);
			vert.m_position = Vector(cosTheta * dist, -sinTheta * dist,  r * sinPhi);
			prim->addVertex(vert);

		}
	
		theta = theta1;
		cosTheta = cosTheta1;
		sinTheta = sinTheta1;
	}
	
	m_rendproc->record();
	m_rend->render(prim);
	m_rendproc->stop();
}

void Torus::render() {

	if (m_vtxshader != NULL)
		m_vtxshader->enable();

	if (m_texcombiner != NULL)
		m_texcombiner->enable();

	if (m_rendproc)
		m_rendproc->execute();

	if (m_vtxshader != NULL)
		m_vtxshader->disable();

	if (m_texcombiner != NULL)
		m_texcombiner->disable();
}

Material* Torus::getMaterial() {
	return m_material;
}

void Torus::setTextureCombiner(TextureCombiner* tc) {
	m_texcombiner = tc;
}

void Torus::setVertexShader(VertexShader* vs) {
	m_vtxshader = vs;
}