#ifndef __TERRAIN_H__
#define __TERRAIN_H__

#include "../optic.h"
#include "../core/opticengine.h"
#include "../core/renderableentity.h"
#include "../renderer/renderer.h"
#include "grid.h"

class TerrainBuildParameters : public BuildParameters {
public:

	TerrainBuildParameters() { }

	op_float width,height,step;
	string filename;
};

class InvalidTerrainFileException : public Exception {
public:

	InvalidTerrainFileException() : Exception("Invalid Terrain File") { }
	InvalidTerrainFileException(const string& s) : Exception("Invalid Terrain File: " + s) { }

};

class Terrain : public RenderableEntity {
public:

	Terrain();
	virtual ~Terrain();

	virtual void build(BuildParameters*);
	virtual void render();

	virtual Fog* getFog();
	virtual void setFogBias(op_float);
	virtual op_float getMaxHeight();

	virtual AABoundingBox getBoundingBox();
	virtual int getNumComponents();
	virtual void getFaces(int,vector<Face>&);
	virtual void getVertices(int,vector<Vertex>&);

private:

	void init_heightdata(const char*);
	Vector getMapCoords(op_float,op_float,op_float,op_float);
	op_float getFogCoord(op_float);
	void getMinMax();

	RenderProc* m_rendproc;
	Fog* m_fog;
	op_float m_fogdepth,m_maxheight,m_minheight,m_bias;

	int m_width,m_height;
	op_float* m_heightdata;
};


#endif