#ifndef __SPHERE_H__
#define __SPHERE_H__

#include "../optic.h"
#include "../core/opticengine.h"
#include "../core/renderableentity.h"
#include "../renderer/renderer.h"
#include "geometrytypes.h"

class SphereBuildParameters : public BuildParameters {
public:
	
	SphereBuildParameters() : radius(5.0f), detail(10) { }

	op_float radius;
	int detail;
};

class Sphere : public RenderableEntity {
public:

	Sphere();

	virtual void build(BuildParameters*);
	virtual void render();

private:
	
	RenderProc* m_rendproc;

};

#endif