#include "sphere.h"

Sphere::Sphere() {
	
	m_rendproc = (RenderProc*) m_rend->newObject(RND_OBJECT_RENDERPROC);
}

void Sphere::build(BuildParameters* params) {
	
	int i,j,detail;
	op_float radius,theta1,theta2,theta3;
	Primitive* prim;
	Vertex vert;
	SphereBuildParameters* sbp = (SphereBuildParameters*) params;

	radius = sbp->radius; detail = sbp->detail;

	prim = (Primitive*) m_rend->newObject(RND_OBJECT_PRIMITIVE);
	prim->setType(PRIM_QUADSTRIP);
	prim->setMaterial(m_material);

	if (radius < 0)
		radius = -radius;
	if (detail < 0)
		detail = -detail;
	
	for (j = 0; j < detail/2; j++) {

		theta1 = j * RND_TWOPI / detail - RND_PIOVER2;
		theta2 = (j + 1) * RND_TWOPI / detail - RND_PIOVER2;
		
		for (i = 0; i <= detail; i++) {
			
			theta3 = i * RND_TWOPI / detail;
			
			vert.m_normal[0] = cos(theta2) * cos(theta3);
			vert.m_normal[1] = sin(theta2);
			vert.m_normal[2] = cos(theta2) * sin(theta3);
			vert.m_position[0] = radius * vert.m_normal[0];
			vert.m_position[1] = radius * vert.m_normal[1];
			vert.m_position[2] = radius * vert.m_normal[2];
			vert.m_texcoords.push_back(Vector(i/(op_float)detail,2*(j+1)/(op_float)detail,0));
			vert.m_texcoords.push_back(Vector(i/(op_float)detail,2*(j+1)/(op_float)detail,0));
			vert.m_texcoords.push_back(Vector(i/(op_float)detail,2*(j+1)/(op_float)detail,0));
			prim->addVertex(vert);
			vert.m_texcoords.clear();
			
			vert.m_normal[0] = cos(theta1) * cos(theta3);
			vert.m_normal[1] = sin(theta1);
			vert.m_normal[2] = cos(theta1) * sin(theta3);
			vert.m_position[0] = radius * vert.m_normal[0];
			vert.m_position[1] = radius * vert.m_normal[1];
			vert.m_position[2] = radius * vert.m_normal[2];	
			vert.m_texcoords.push_back(Vector(i/(op_float)detail,2*(j)/(op_float)detail,0));
			vert.m_texcoords.push_back(Vector(i/(op_float)detail,2*(j)/(op_float)detail,0));
			vert.m_texcoords.push_back(Vector(i/(op_float)detail,2*(j)/(op_float)detail,0));
			prim->addVertex(vert);
			vert.m_texcoords.clear();

		}
		
	}	
	
	m_rendproc->record();
	m_rend->render(prim);
	m_rendproc->stop();

}

void Sphere::render() {

	enableShaders();

	if (m_rendproc)
		m_rendproc->execute();

	disableShaders();
}
