#ifndef __SKYBOX_H__
#define __SKYBOX_H__

#include "../optic.h"
#include "../core/opticengine.h"
#include "../core/renderableentity.h"
#include "../renderer/renderer.h"

class SkyBoxBuildParameters : public BuildParameters {
public:

	SkyBoxBuildParameters() : width(500), height(500), depth(500) { }

	op_float width,height,depth;
};

class SkyBox : public RenderableEntity {
public:

	SkyBox();

	virtual void build(BuildParameters*);
	virtual void render();

	virtual AABoundingBox getBoundingBox();
	virtual int getNumComponents();
	virtual void getFaces(int,vector<Face>&);
	virtual void getVertices(int,vector<Vertex>&);

private:

	RenderProc* m_rendproc;

};

#endif