#include "skybox.h"

SkyBox::SkyBox() {

	m_rendproc = (RenderProc*) m_rend->newObject(RND_OBJECT_RENDERPROC);
}

void SkyBox::build(BuildParameters* params) {

	SkyBoxBuildParameters* sbb = (SkyBoxBuildParameters*) params;
	Primitive* m_faces[6];
	Vertex verts[4];
	int i;
	op_float width,height,length;

	width = sbb->width; height = sbb->height; length = sbb->depth;

	// Pos X
	m_faces[0] = (Primitive*) m_rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[0]->setType(PRIM_QUAD);
	m_faces[0]->getMaterial()->addTexture(m_material->getTexture(0));
	m_faces[0]->getMaterial()->getTexture(0)->setWrapMode(TEXTURE_COORD_S | TEXTURE_COORD_T,TEXTURE_WRAP_EDGECLAMP);
	verts[0].m_position = Vector(width,-height,-length); verts[0].m_normal = Vector(-1,0,0); verts[2].m_texcoords.push_back(Vector(0,0,0));
	verts[1].m_position = Vector(width,-height,length); verts[1].m_normal = Vector(-1,0,0); verts[3].m_texcoords.push_back(Vector(1,0,0));
	verts[2].m_position = Vector(width,height,length); verts[2].m_normal = Vector(-1,0,0); verts[0].m_texcoords.push_back(Vector(1,1,0));
	verts[3].m_position = Vector(width,height,-length); verts[3].m_normal = Vector(-1,0,0); verts[1].m_texcoords.push_back(Vector(0,1,0));
	for (i = 0; i < 4; i++) {
		m_faces[0]->addVertex(verts[i]);
		verts[i].m_texcoords.clear();
	}

	// Neg X
	m_faces[1] = (Primitive*) m_rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[1]->setType(PRIM_QUAD);
	m_faces[1]->getMaterial()->addTexture(m_material->getTexture(1));
	m_faces[1]->getMaterial()->getTexture(0)->setWrapMode(TEXTURE_COORD_S | TEXTURE_COORD_T,TEXTURE_WRAP_EDGECLAMP);
	verts[0].m_position = Vector(-width,-height,-length); verts[0].m_normal = Vector(1,0,0); verts[2].m_texcoords.push_back(Vector(1,0,0));
	verts[1].m_position = Vector(-width,-height,length); verts[1].m_normal = Vector(1,0,0); verts[3].m_texcoords.push_back(Vector(0,0,0));
	verts[2].m_position = Vector(-width,height,length); verts[2].m_normal = Vector(1,0,0); verts[0].m_texcoords.push_back(Vector(0,1,0));
	verts[3].m_position = Vector(-width,height,-length); verts[3].m_normal = Vector(1,0,0); verts[1].m_texcoords.push_back(Vector(1,1,0));
	for (i = 0; i < 4; i++) {
		m_faces[1]->addVertex(verts[i]);
		verts[i].m_texcoords.clear();
	}

	// Pos Y
	m_faces[2] = (Primitive*) m_rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[2]->setType(PRIM_QUAD);
	m_faces[2]->getMaterial()->addTexture(m_material->getTexture(2));
	m_faces[2]->getMaterial()->getTexture(0)->setWrapMode(TEXTURE_COORD_S | TEXTURE_COORD_T,TEXTURE_WRAP_EDGECLAMP);
	verts[0].m_position = Vector(-width,height,-length); verts[0].m_normal = Vector(0,-1,0); verts[0].m_texcoords.push_back(Vector(0,0,0));
	verts[1].m_position = Vector(-width,height,length); verts[1].m_normal = Vector(0,-1,0); verts[3].m_texcoords.push_back(Vector(1,0,0));
	verts[2].m_position = Vector(width,height,length); verts[2].m_normal = Vector(0,-1,0); verts[2].m_texcoords.push_back(Vector(1,1,0));
	verts[3].m_position = Vector(width,height,-length); verts[3].m_normal = Vector(0,-1,0); verts[1].m_texcoords.push_back(Vector(0,1,0));
	for (i = 0; i < 4; i++) {
		m_faces[2]->addVertex(verts[i]);
		verts[i].m_texcoords.clear();
	}

	// Neg Y
	m_faces[3] = (Primitive*) m_rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[3]->setType(PRIM_QUAD);
	m_faces[3]->getMaterial()->addTexture(m_material->getTexture(3));
	m_faces[3]->getMaterial()->getTexture(0)->setWrapMode(TEXTURE_COORD_S | TEXTURE_COORD_T,TEXTURE_WRAP_EDGECLAMP);
	verts[0].m_position = Vector(-width,-height,-length); verts[0].m_normal = Vector(0,1,0); verts[1].m_texcoords.push_back(Vector(0,0,0));
	verts[1].m_position = Vector(-width,-height,length); verts[1].m_normal = Vector(0,1,0); verts[2].m_texcoords.push_back(Vector(1,0,0));
	verts[2].m_position = Vector(width,-height,length); verts[2].m_normal = Vector(0,1,0); verts[3].m_texcoords.push_back(Vector(1,1,0));
	verts[3].m_position = Vector(width,-height,-length); verts[3].m_normal = Vector(0,1,0); verts[0].m_texcoords.push_back(Vector(0,1,0));
	for (i = 0; i < 4; i++) {
		m_faces[3]->addVertex(verts[i]);
		verts[i].m_texcoords.clear();
	}

	// Pos Z
	m_faces[4] = (Primitive*) m_rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[4]->setType(PRIM_QUAD);
	m_faces[4]->getMaterial()->addTexture(m_material->getTexture(4));
	m_faces[4]->getMaterial()->getTexture(0)->setWrapMode(TEXTURE_COORD_S | TEXTURE_COORD_T,TEXTURE_WRAP_EDGECLAMP);
	verts[0].m_position = Vector(-width,-height,length); verts[0].m_normal = Vector(0,0,-1); verts[3].m_texcoords.push_back(Vector(0,0,0));
	verts[1].m_position = Vector(width,-height,length); verts[1].m_normal = Vector(0,0,-1); verts[2].m_texcoords.push_back(Vector(1,0,0));
	verts[2].m_position = Vector(width,height,length); verts[2].m_normal = Vector(0,0,-1); verts[1].m_texcoords.push_back(Vector(1,1,0));
	verts[3].m_position = Vector(-width,height,length); verts[3].m_normal = Vector(0,0,-1); verts[0].m_texcoords.push_back(Vector(0,1,0));
	for (i = 0; i < 4; i++) {
		m_faces[4]->addVertex(verts[i]);
		verts[i].m_texcoords.clear();
	}

	// Neg Z
	m_faces[5] = (Primitive*) m_rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[5]->setType(PRIM_QUAD);
	m_faces[5]->getMaterial()->addTexture(m_material->getTexture(5));
	m_faces[5]->getMaterial()->getTexture(0)->setWrapMode(TEXTURE_COORD_S | TEXTURE_COORD_T,TEXTURE_WRAP_EDGECLAMP);
	verts[0].m_position = Vector(-width,-height,-length); verts[0].m_normal = Vector(0,0,1); verts[3].m_texcoords.push_back(Vector(1,0,0));
	verts[1].m_position = Vector(width,-height,-length); verts[1].m_normal = Vector(0,0,1); verts[2].m_texcoords.push_back(Vector(0,0,0));
	verts[2].m_position = Vector(width,height,-length); verts[2].m_normal = Vector(0,0,1); verts[1].m_texcoords.push_back(Vector(0,1,0));
	verts[3].m_position = Vector(-width,height,-length); verts[3].m_normal = Vector(0,0,1); verts[0].m_texcoords.push_back(Vector(1,1,0));
	for (i = 0; i < 4; i++) {
		m_faces[5]->addVertex(verts[i]);
		verts[i].m_texcoords.clear();
	}
	
	m_rendproc->record();
	for (i = 0; i < 6; i++)
		m_rend->render(m_faces[i]);
	m_rendproc->stop();
}

void SkyBox::render() {

	enableShaders();

	if (m_rendproc)
		m_rendproc->execute();

	disableShaders();
}

AABoundingBox SkyBox::getBoundingBox() {
	return AABoundingBox();
}

int SkyBox::getNumComponents() {
	return 1;
}

void SkyBox::getFaces(int comp, vector<Face>& faces) {

}

void SkyBox::getVertices(int comp, vector<Vertex>& vertices) {

}