#ifndef __PARTICLEEMITTER_H__
#define __PARTICLEEMITTER_H__

#include "../optic.h"
#include "particle.h"
#include "../core/opticengine.h"

class ParticleEmitter {
public:

	ParticleEmitter();
	virtual ~ParticleEmitter();

	void begin();
	void forceEnd();
	bool isActive();

	void render();
	void update(op_float);

	void setMaxParticles(int);
	void setEndTime(op_float);
	void setAxisAngle(const Vector&,const pair<op_float,op_float>&);
	void setPosition(const Vector&);
	void setRotation(const Vector&);
	void setTranslation(const Vector&);
	void setRange(pair<op_float,op_float>*);
	void setParticleTemplate(const ParticleTemplate&);
	void setNewPerStep(int);
	void setMagRange(const pair<op_float,op_float>&);

private:

	void reset_particle(Particle&);
	void create_new_particles();

	bool m_active,m_materialcreated;

	int m_maxparticles,m_newperstep;
	ParticleTemplate m_template;
	vector<Particle> m_particles;
	op_float m_endtime;
	Vector m_axis;
	pair<op_float,op_float> m_angle;
	pair<op_float,op_float> m_magrange;
	Vector m_position,m_rotation,m_translation;
	pair<op_float,op_float> m_range[3];
	Orientation*m_orient;
	Renderer* m_rend;
	Timer* m_timer;
};

#endif