#include "particleemitter.h"

ParticleEmitter::ParticleEmitter() : m_materialcreated(false) {

	ACQUIRE_RENDERER(m_rend,g_engine)

}

ParticleEmitter::~ParticleEmitter() {

}

void ParticleEmitter::update(op_float dt) {

	int i;

	for (i = 0; i < m_particles.size(); i++) {
		m_particles[i].update(dt);
		if (!m_particles[i].isAlive())
			reset_particle(m_particles[i]);
	}

	if (m_particles.size() < m_maxparticles)
		create_new_particles();

}

void ParticleEmitter::create_new_particles() {
	
	int i;
	Particle particle;
	Texture* tex;

	for (i = 0; i < m_newperstep; i++) {

		particle.m_accel = Vector(0,0,0); //Temp
		particle.m_life = randomFloat(m_template.m_liferange.first,m_template.m_liferange.second);
		particle.m_mass = randomFloat(m_template.m_massrange.first,m_template.m_massrange.second);
		particle.m_maxlife = particle.m_life;
		particle.m_fadefunc = m_template.fadefunc;
		particle.m_fadeconstant = randomFloat(m_template.m_fadeconstant.first,m_template.m_fadeconstant.second);
		
		if (!m_materialcreated) {

			particle.m_material = (Material*) m_rend->newObject(RND_OBJECT_MATERIAL);
			particle.m_material->setDiffuse(m_template.m_color);

			if (m_template.m_texture != "NONE") {
				RND_NEW2DMIPTEXTURE(tex,m_rend,m_template.m_texture)

				particle.m_material->addTexture(tex);
			}

			m_materialcreated = true;
		}

		reset_particle(particle);
		m_particles.push_back(particle);
	}

}

void ParticleEmitter::reset_particle(Particle& particle) {

	op_float angle,mag;
	Vector rawvelocity;
	
	particle.m_life = particle.m_maxlife;
	
	particle.m_position = Vector(randomFloat(m_range[0].first,m_range[0].second),
								 randomFloat(m_range[1].first,m_range[1].second),
								 randomFloat(m_range[2].first,m_range[2].second));

	angle = randomFloat(m_angle.first,m_angle.second);
	mag = randomFloat(m_magrange.first,m_magrange.second);
	rawvelocity = (Vector(cos(angle),sin(angle),randomFloat(-2,2))).normalize();

	// Rotate velocity vector in accordance with the axis

	particle.m_velocity = rawvelocity;
								 
}

void ParticleEmitter::begin() {
	m_active = true;
}

void ParticleEmitter::forceEnd() {
	m_active = false;
}

bool ParticleEmitter::isActive() {
	return m_active;
}

void ParticleEmitter::render() {

/*	int i;

	if (m_particles.size() == 0)
		return;

	m_rend->getCamera()->push();
	m_orien->enable();
	m_particles[0]->m_material->bindAll();
	for (i = 0; i < m_particles.size(); i++) {
		// Build billboard and render
	}

	m_particles[0]->m_material->unbindTextures();
	m_rend->getCamera()->pop();*/
}

void ParticleEmitter::setAxisAngle(const Vector& axis,const pair<op_float,op_float>& angle) {
	m_axis = axis;
	m_angle = angle;
}

void ParticleEmitter::setEndTime(op_float endtime) {
	m_endtime = endtime;
}

void ParticleEmitter::setMaxParticles(int maxparticles) {
	m_maxparticles = maxparticles;
}

void ParticleEmitter::setPosition(const Vector& position) {
	m_position = position;
}

void ParticleEmitter::setRange(pair<op_float,op_float>* range) {
	m_range[0] = range[0];
	m_range[1] = range[1];
	m_range[2] = range[2];
}

void ParticleEmitter::setRotation(const Vector& rotation) {
	m_rotation = rotation;
}

void ParticleEmitter::setParticleTemplate(const ParticleTemplate& particle) {
	m_template = particle;
}

void ParticleEmitter::setTranslation(const Vector& translation) {
	m_translation = translation;
}

void ParticleEmitter::setNewPerStep(int newperstep) {
	m_newperstep = newperstep;
}

void ParticleEmitter::setMagRange(const pair<op_float,op_float>& range) {
	m_magrange = range;
}
