#ifndef __QUATORIENTATION_H__
#define __QUATORIENTATION_H__

#include "../optic.h"
#include "../renderer/renderer.h"

class Orientation {
public:

	Orientation(Transformer*);

	virtual void enable();

	virtual void rotate_axisangle(const Vector&, op_float);
	virtual void rotate_euler(op_float,op_float,op_float);
	virtual void rotate_quaternion(const Quaternion&);
	virtual void translate(const Vector&, bool compose = false);
	virtual void scale(const Vector&);

	virtual void compose(Orientation*);

	virtual void interpolate(Orientation*,Orientation*,op_float);

	virtual Quaternion getQuat() const;
	virtual Vector getPosition() const;

private:

	Transformer* m_transformer;
	Quaternion m_quat;
	Vector m_trans,m_scale;
	bool m_scaled;
};

#endif