#include "orientation.h"

Orientation::Orientation(Transformer* transformer) : m_transformer(transformer), m_scaled(false) {

}

void Orientation::enable() {
	
	Vector axis;
	op_float angle;

	m_transformer->translate(m_trans);
	m_quat.getAxisAngle(angle,axis);
	m_transformer->rotate_axisangle(RADTODEG(angle),axis);

	if (m_scaled)
		m_transformer->scale(m_scale);
}

void Orientation::rotate_axisangle(const Vector& axis, op_float angle) {
	
	m_quat.rotation(angle,axis);
	m_quat = m_quat.normalize();
}

void Orientation::rotate_euler(op_float roll, op_float pitch, op_float yaw) {

	op_float ex,ey,ez;		
	op_float cr,cp,cy,sr,sp,sy,cpcy,spsy;		

	ex = DEGTORAD(roll)/2.0f; ey = DEGTORAD(pitch)/2.0f; ez = DEGTORAD(yaw)/2.0f;
	cr = (op_float)cos(ex); cp = (op_float)cos(ey); cy = (op_float)cos(ez);
	sr = (op_float)sin(ex); sp = (op_float)sin(ey); sy = (op_float)sin(ez);

	cpcy = cp * cy;
	spsy = sp * sy;

	m_quat[0] = op_float(cr * cpcy + sr * spsy);
	m_quat[1] = op_float(sr * cpcy - cr * spsy);
	m_quat[2] = op_float(cr * sp * cy + sr * cp * sy);
	m_quat[3] = op_float(cr * cp * sy - sr * sp * cy);

	m_quat = m_quat.normalize();

}

void Orientation::rotate_quaternion(const Quaternion& quat) {
	m_quat = quat;
}

void Orientation::compose(Orientation* o2) {

	m_quat = (m_quat * o2->getQuat()).normalize();
	
}

void Orientation::translate(const Vector& trans, bool compose) {

	if (!compose)
		m_trans = trans;
	else
		m_trans += trans;
}

void Orientation::interpolate(Orientation* o1, Orientation* o2, op_float t) {

	m_quat.slerp(o1->getQuat(),o2->getQuat(),t);
}

Quaternion Orientation::getQuat() const {
	return m_quat;
}

Vector Orientation::getPosition() const {
	return m_trans;
}

void Orientation::scale(const Vector& scalar) {
	m_scaled = true;
	m_scale = scalar;
}