#ifndef __OCTREE_H__
#define __OCTREE_H__

#include "../optic.h"
#include "../core/opticengine.h"
#include "../core/renderableentity.h"
#include "aaboundingbox.h"

class Octree {
public:

	Octree();

	void render();

	void build(int,int);
	void insert(RenderableEntity*);

private:

	void render_help(Frustum*);

	void assign_nodes(int);
	int count_triangles();
	int finalize_node();
	VertexArray* build_vtxarray(const vector<Face>&,const vector<Vertex>&, int&);
	void subdivide();
	void get_toplevel_extents();
	
	bool m_isLeaf;
	AABoundingBox m_box;
	Octree* m_chils[8];
	RenderProc* m_rendproc;
	Renderer* m_rend;

	static int m_maxtris,m_maxdepth;
	static vector<RenderableEntity*> m_objects;

};

#endif