#ifndef __OCTGEOMMAN_H__
#define __OCTGEOMMAN_H__

#include "../core/opticengine.h"
#include "../core/renderableentity.h"
#include "geometrymanager.h"
#include "octree.h"

class NonStaticGeometryException : public Exception {
public:

	NonStaticGeometryException() : Exception("Octree Geometry Entry Non-Static Failure") { }
	NonStaticGeometryException(const string& s) : Exception("Octree Geometry Entry Non-Static Failure: " + s) { }

};

class OctreeGeometryManager : public GeometryManager {
public:

	OctreeGeometryManager(bool);
	
	virtual void render(bool clear = true);
	virtual void update(op_float);

	virtual void setViewer(ViewableEntity*);
	virtual ViewableEntity* getViewer();
	
	virtual void insert(RenderableEntity*, bool asWhole, bool cull);

	virtual void remove(RenderableEntity*);
	
	virtual void compile();

private:

	void setView();
	void renderWhole(const pair<RenderableEntity*,bool>&);

	Octree* m_tree;
	ViewableEntity* m_viewer;
	Renderer* m_rend;
	Frustum* m_frust;
	bool m_treedisabled;

	vector< pair<RenderableEntity*, bool> > m_wholes;
};

#endif