#include "octgeomman.h"

OctreeGeometryManager::OctreeGeometryManager(bool enabletree) : m_treedisabled(!enabletree) {
	
	ACQUIRE_RENDERER(m_rend,g_engine)
		
	m_tree = new Octree();
	m_frust = (Frustum*) m_rend->newObject(RND_OBJECT_FRUSTUM);
	if (m_treedisabled)
		g_log->writeLine("OCTGEOMMAN: OCTREE Disabled");
}

void OctreeGeometryManager::render(bool clear) {
	
	int i;

	if (clear)
		m_rend->clearBuffers();

	setView();

	m_tree->render();
	for (i = 0; i < m_wholes.size(); i++) 
		renderWhole(m_wholes[i]);	
	
}

void OctreeGeometryManager::update(op_float dt) {

	int i;

	for (i = 0; i < m_wholes.size(); i++) {
		if (!m_wholes[i].first->isStaticGeometry())
			m_wholes[i].first->update(dt);
	}
	
}

void OctreeGeometryManager::compile() {
	m_tree->build(3000,3);
}

void OctreeGeometryManager::setView() {
	
	RenderableEntity* pRnd;
	
	if (m_viewer->getCamera()->isLockedTrackball())
		m_viewer->getCamera()->updateTrackball();
	
	m_rend->getCamera()->identity();
	m_viewer->view();
	
	if (m_viewer->QueryInterface(Entity::RENDERABLE,(void**)&pRnd))
		renderWhole(pair<RenderableEntity*,bool>(pRnd,false));
}

void OctreeGeometryManager::renderWhole(const pair<RenderableEntity*,bool>& ent) {
	
	AABoundingBox box;
	Matrix model(4,4),proj(4,4);
	
	m_frust->calcFrustum(model,proj);
	
	m_rend->getCamera()->push();
	
	ent.first->getOrientation()->enable();

	if (ent.second) {
		m_rend->getCamera()->bind(TRANS_MATRIX_PROJECTION);
		m_rend->getCamera()->getCurrentMatrix(proj);
		m_rend->getCamera()->bind(TRANS_MATRIX_WORLD);
		m_rend->getCamera()->getCurrentMatrix(model);
		m_frust->calcFrustum(model,proj);
		
		box = ent.first->getBoundingBox();
		if (!m_frust->cullBox(box.getLocation(),box.getExtents())) 
			ent.first->render();
		
	}
	else 
		ent.first->render();
	
	
	m_rend->getCamera()->pop();

}

void OctreeGeometryManager::insert(RenderableEntity* ent, bool asWhole, bool cull) {

	if (asWhole || m_treedisabled)
		m_wholes.push_back(pair<RenderableEntity*,bool>(ent,cull));
	else {
		if (ent->isStaticGeometry())
			m_tree->insert(ent);
		else
			throw NonStaticGeometryException();
	}

}

void OctreeGeometryManager::remove(RenderableEntity* ent) {

	int i;
	vector< pair<RenderableEntity*,bool> > temp;

	for (i = 0; i < m_wholes.size(); i++)
		if (m_wholes[i].first != ent)
			temp.push_back(m_wholes[i]);

	m_wholes.clear();

	for (i = 0; i < temp.size(); i++)
		m_wholes.push_back(temp[i]);
}

void OctreeGeometryManager::setViewer(ViewableEntity* ent) {
	m_viewer = ent;
}

ViewableEntity* OctreeGeometryManager::getViewer() {
	return m_viewer;
}