#ifndef __MESH_H__
#define __MESH_H__

#include "../optic.h"
#include "../core/renderableentity.h"
#include "3dsmesh.h"

class MeshBuildParameters : public BuildParameters {
public:

	MeshBuildParameters() { }

	string m_filename;
};

class Mesh : public RenderableEntity {
public:

	Mesh();

	virtual void build(BuildParameters*);
	virtual void render();

	virtual AABoundingBox getBoundingBox();

	virtual int getNumComponents();
	virtual void getFaces(int,vector<Face>&);
	virtual void getVertices(int,vector<Vertex>&);

	virtual bool QueryInterface(const EntityType, void**);

private:

	VertexArray* m_array;
	RenderProc* m_rendproc;

	void make_renderproc();
	void make_boundingbox();

	// 3DS File Mayhem
	void load3DS(const char*);
	void proc_3ds_normals();
	void proc_3ds_indices();
	void proc_3ds_textures();
	void proc_3ds_chunk(tChunk*);
	void proc_3ds_object_chunk(t3DObject*,tChunk*);
	void proc_3ds_mat_chunk(tChunk*);
	void read_3ds_chunk(tChunk*);
	void read_3ds_color_chunk(tMaterialInfo*,tChunk*);
	void read_3ds_vertices(t3DObject*,tChunk*);
	void read_3ds_vertex_indices(t3DObject*,tChunk*);
	void read_3ds_texture_coords(t3DObject*, tChunk*);
	void read_3ds_object_material(t3DObject*,tChunk*);
	int read_3ds_string(char*);

	t3DModel* m_model;
	vector<Texture*> m_textures;
	AABoundingBox m_box;
	FILE* m_file;
};

#endif