#include "grid.h"

Grid::Grid() : m_texcombiner(NULL), m_shader(NULL){ 

}

void Grid::build(op_float width, op_float height, int tess) {

	int i;
	op_float wstep,hstep,row,col,s,t;
	Vertex vert;
	Primitive* prow;
	
	m_rend = (Renderer*) g_engine->getSubSystem(OPTIC_SUBSYS_RENDERER);

	m_material = (Material*) m_rend->newObject(RND_OBJECT_MATERIAL);
	for (i = 0; i < m_textures.size(); i++)
		m_material->addTexture(m_textures[i]);

	wstep = (width/((op_float)tess));
	hstep = (height/((op_float)tess));

	m_rows.clear();

	for (row = 0; row+hstep <= height; row += hstep) {
		
		prow = (Primitive*) m_rend->newObject(RND_OBJECT_PRIMITIVE);
		prow->setType(PRIM_QUADSTRIP);
		prow->setMaterial(m_material);

		for (col = 0; col <= width; col += wstep) {
			
			vert.m_position = Vector(col,row,0); vert.m_normal = Vector(0,0,1);
			s = col/width; t = row/height;
			vert.m_texcoords.push_back(Vector(s,t,0)); vert.m_texcoords.push_back(Vector(s,t,0)); vert.m_texcoords.push_back(Vector(s,t,0));
			prow->addVertex(vert);
			vert.m_texcoords.clear();

			vert.m_position = Vector(col,row+hstep,0); vert.m_normal = Vector(0,0,1);
			s = col/width; t = (row+hstep)/height;
			vert.m_texcoords.push_back(Vector(s,t,0)); vert.m_texcoords.push_back(Vector(s,t,0)); vert.m_texcoords.push_back(Vector(s,t,0));
			prow->addVertex(vert);
			vert.m_texcoords.clear();

	
		}
	
		m_rows.push_back(prow);
	}

}

void Grid::render() {

	int i;

	if (m_shader != NULL)
		m_shader->enable();

	if (m_texcombiner != NULL)
		m_rend->setTexCombiner(m_texcombiner);

	for (i = 0; i < m_rows.size(); i++)
		m_rend->render(m_rows[i]);

	if (m_shader != NULL)
		m_shader->disable();

	if (m_texcombiner != NULL)
		m_rend->setTexCombiner(NULL);
}

void Grid::modifyVertex(int row, int col, const Vertex& v) {

	m_rows[row]->getVertex(2*col) = v;
	
	if (row > 0)
		m_rows[row-1]->getVertex(2*col+1) = v;
}

Vertex& Grid::getVertex(int row, int col) {

	return m_rows[row]->getVertex(2*col);
}

int Grid::getCols() {
	
	return m_rows[0]->getNumVertices()/2;

}

int Grid::getRows() {
	return m_rows.size();
}

void Grid::addTexture(Texture* texture) {
	m_textures.push_back(texture);
}

Material* Grid::getMaterial() {
	return m_material;
}

void Grid::setTextureCombiner(TextureCombiner* tc) {
	m_texcombiner = tc;
}

void Grid::setVertexShader(VertexShader* vs) {
	m_shader = vs;
}