#ifndef __DISPLAYMANAGER_H__
#define __DISPLAYMANAGER_H__

#include "../optic.h"
#include "../renderer/renderer.h"
#include "../core/renderableentity.h"
#include "../core/basicviewer.h"
#include "../core/entitymanager.h"
#include "../input/input.h"

#define DMAN_FONT_TNR14B			0x0
#define DMAN_FONT_TNR20B			0x1

#define DMAN_VTXSHADER_MAXSHADERS	7
#define DMAN_VTXSHADER_BASIC		0x0
#define DMAN_VTXSHADER_TERRAIN		0x1
#define DMAN_VTXSHADER_ANISO		0x2
#define DMAN_VTXSHADER_GLARECUBE	0x3
#define DMAN_VTXSHADER_RIPPLECUBE	0x4
#define DMAN_VTXSHADER_CUBEMAPLIGHT	0x5
#define DMAN_VTXSHADER_CUBEMAPONLY	0x6

class GraphicsManager {
public:

	GraphicsManager(EntityManager*, Renderer*, InputManager*);

	void init();

	virtual Renderer* getRenderer();

	virtual ViewableEntity* getBasicViewer();
	virtual Texture* create2DMipmap(const char*);
	virtual Texture* create2DTexture(const char*);
	virtual Texture* createCubeMap(const char*);
	virtual VertexShader* createVertexShader(const char*);
	virtual PixelShader* createPixelShader(const char*);
	virtual Font* createFont(const char*,int);
	virtual Font* getStoredFont(int);
	virtual VertexShader* getStoredVertexShader(int);

protected:

	void drawMouse();

	EntityManager* m_entman;
	Renderer* m_rend;
	InputManager* m_inp;
	Font* m_fonts[2];
	VertexShader* m_shaders[DMAN_VTXSHADER_MAXSHADERS];
	ViewableEntity* m_camera;
	int m_mouse;

};

#endif