#include "graphicsmanager.h"
#include "../core/demo.h"

GraphicsManager::GraphicsManager(EntityManager* entman, Renderer* rend, InputManager* inp) 
		: m_entman(entman), m_rend(rend), m_inp(inp) {

	int i;
	
	for (i = 0; i < DMAN_VTXSHADER_MAXSHADERS; i++)
		m_shaders[i] = NULL;
}

void GraphicsManager::init() {

	vector<int> channels;
	VertexShader* shader;
		
	m_fonts[DMAN_FONT_TNR14B] = (Font*) m_rend->newObject(RND_OBJECT_FONT);
	m_fonts[DMAN_FONT_TNR14B]->create("Times New Roman",14,FONT_STYLE_BOLD,Triple(1,1,1),m_rend->getWindow());
	
	m_fonts[DMAN_FONT_TNR20B] = (Font*) m_rend->newObject(RND_OBJECT_FONT);
	m_fonts[DMAN_FONT_TNR20B]->create("Times New Roman",20,FONT_STYLE_BOLD,Triple(1,1,1),m_rend->getWindow());
	
	m_inp->getChannels(channels,m_inp->getCommonDevice(INPUT_COMMON_MOUSE));
	m_mouse = channels[0];
	
	m_camera = (ViewableEntity*) m_entman->create("basicviewer");
	
	shader = createVertexShader("basic.vsd");
	shader->trackMatrix(0,TRANS_MATRIX_COMPOSITE, VTXSHADER_TRANS_IDENTITY);
	shader->trackMatrix(4,TRANS_MATRIX_WORLD, VTXSHADER_TRANS_IDENTITY);
	shader->trackMatrix(8,TRANS_MATRIX_WORLD, VTXSHADER_TRANS_INVERSETRANSPOSE);
	shader->trackMatrix(12,TRANS_MATRIX_PROJECTION, VTXSHADER_TRANS_IDENTITY);
	shader->trackMatrix(16,TRANS_MATRIX_WORLD,VTXSHADER_TRANS_INVERSE);
	shader->setConstant(22,Vector(0,0,0,0));
	m_shaders[DMAN_VTXSHADER_BASIC] = shader;

}

Renderer* GraphicsManager::getRenderer() {
	return m_rend;
}

ViewableEntity* GraphicsManager::getBasicViewer() {
	return m_camera;
}

Texture* GraphicsManager::create2DMipmap(const char* filename) {

	Texture* tex;

	RND_NEW2DMIPTEXTURE(tex,m_rend,filename)

	return tex;
}

Texture* GraphicsManager::create2DTexture(const char* filename) {

	Texture* tex;
	
	RND_NEW2DTEXTURE(tex,m_rend,filename)

	return tex;
}

Texture* GraphicsManager::createCubeMap(const char* filename) {

	Texture* tex;

	tex = (Texture*) m_rend->newObject(RND_OBJECT_TEXTURE);
	tex->create(filename,TEXTURE_TYPE_CUBEMAP);
	tex->setTexGen(TEXTURE_COORD_S | TEXTURE_COORD_T | TEXTURE_COORD_R, TEXTURE_GEN_CUBEMAP);

	return tex;
}

VertexShader* GraphicsManager::createVertexShader(const char* filename) {

	VertexShader* vtx;

	RND_NEWVTXSHADER(vtx,m_rend,filename)

	return vtx;
}

PixelShader* GraphicsManager::createPixelShader(const char* filename) {
	
	PixelShader* pxl;

	RND_NEWPIXELSHADER(pxl,m_rend,filename)

	return pxl;
}

Font* GraphicsManager::createFont(const char* face, int size) {

	Font* font;

	font = (Font*) m_rend->newObject(RND_OBJECT_FONT);
	font->create(face,size,FONT_STYLE_BOLD,Triple(1,1,1),m_rend->getWindow());

	return font;
}

Font* GraphicsManager::getStoredFont(int font) {

	return m_fonts[font];

}

VertexShader* GraphicsManager::getStoredVertexShader(int shader) {
	
	if (m_shaders[shader] == NULL) {
		switch (shader) {
		case DMAN_VTXSHADER_TERRAIN:
			m_shaders[DMAN_VTXSHADER_TERRAIN] = createVertexShader("terrain.vsd");
			break;
		case DMAN_VTXSHADER_ANISO:
			m_shaders[DMAN_VTXSHADER_ANISO] = createVertexShader("anisolight.vsd");
			break;
		case DMAN_VTXSHADER_GLARECUBE:
			m_shaders[DMAN_VTXSHADER_GLARECUBE] = createVertexShader("speccube.vsd");
			break;
		case DMAN_VTXSHADER_RIPPLECUBE: 
			m_shaders[DMAN_VTXSHADER_RIPPLECUBE] = createVertexShader("ripple.vsd");
			break;
		case DMAN_VTXSHADER_CUBEMAPLIGHT:
			m_shaders[DMAN_VTXSHADER_CUBEMAPLIGHT] = createVertexShader("basic_cubemap1.vsd");
			break;
		case DMAN_VTXSHADER_CUBEMAPONLY:
			m_shaders[DMAN_VTXSHADER_CUBEMAPONLY] = createVertexShader("cubemap_only.vsd");
			break;
		};
	}
	
	return m_shaders[shader];
}

void GraphicsManager::drawMouse() {

	Vector pos = m_inp->pollChannel(m_mouse).m_trackposition;

	m_rend->text((int)pos[0],(int)pos[1],m_fonts[DMAN_FONT_TNR20B],"M");
}