#ifndef __GEOMETRYMANAGER_H__
#define __GEOMETRYMANAGER_H__

#include "../optic.h"
#include "../core/renderableentity.h"
#include "../core/viewableentity.h"

class GeometryManager {
public:

	GeometryManager() { }

	virtual void render(bool clear = true)=0;
	virtual void update(op_float)=0;

	virtual void setViewer(ViewableEntity*)=0;
	virtual ViewableEntity* getViewer()=0;

	// Insert can do work if it wants
	virtual void insert(RenderableEntity*, bool asWhole, bool cull)=0;
	virtual void remove(RenderableEntity*)=0;

	// Or all work can be saved for compile
	virtual void compile()=0;

};

#endif