#ifndef __DISPLAYMANAGER_H__
#define __DISPLAYMANAGER_H__

#include "../optic.h"
#include "../renderer/renderer.h"
#include "../core/renderableentity.h"
#include "../core/basicviewer.h"
#include "../input/input.h"

#define DMAN_FONT_TNR14B			0x0
#define DMAN_FONT_TNR20B			0x1

#define DMAN_VTXSHADER_BASIC		0x1
#define DMAN_VTXSHADER_TERRAIN		0x2
#define DMAN_VTXSHADER_ANISO		0x3
#define DMAN_VTXSHADER_GLARECUBE	0x4
#define DMAN_VTXSHADER_RIPPLECUBE	0x5

class DisplayManager {
public:

	DisplayManager(Renderer*, InputManager*);

	void init();

	virtual void renderScene(void*);
	virtual void renderEntity(RenderableEntity*);
	
	virtual void initFrame();
	virtual void setViewer(ViewableEntity*);
	virtual ViewableEntity* getViewer();

	virtual Texture* create2DMipmap(const char*);
	virtual Texture* create2DTexture(const char*);
	virtual Texture* createCubeMap(const char*);
	virtual VertexShader* createVertexShader(const char*);
	virtual PixelShader* createPixelShader(const char*);
	virtual Font* createFont(const char*,int);
	virtual Font* getStoredFont(int);
	virtual VertexShader* getStoredVertexShader(int);

protected:

	void drawMouse();

	ViewableEntity* m_camera;
	Renderer* m_rend;
	InputManager* m_inp;
	Font* m_fonts[2];
	VertexShader* m_shaders[4];
	int m_mouse;

};

#endif